/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.persistence;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class PersistenceSetupWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "PersistenceSetupWizardPage.projectName";
    static final String PROVIDER_NAME = "PersistenceSetupWizardPage.providerName";
    static final String CONTAINER_NAME = "PersistenceSetupWizardPage.containerName";
    private static final String defaultProvider = "HIBERNATE";
    private static final String defaultContainer = "JBOSS_AS7";

    protected PersistenceSetupWizardPage() {
        super("org.jboss.tools.forge.ui.wizard.persistence", "Set Up Persistence", null);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        this.createProjectEditor(control);
        this.createProviderEditor(control);
        this.createContainerEditor(control);
        this.setControl((Control)control);
    }

    private void createProjectEditor(Composite parent) {
        IProject[] allProjects;
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("Project: ");
        final Combo projectNameCombo = new Combo(parent, 12);
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!WizardsHelper.isJPAProject(project)) {
                projectNameCombo.add(project.getName());
            }
            ++n2;
        }
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName != null) {
            projectNameCombo.setText(projectName);
        }
        projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PersistenceSetupWizardPage.this.getWizardDescriptor().put(PersistenceSetupWizardPage.PROJECT_NAME, projectNameCombo.getText());
            }
        });
        projectNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button newProjectButton = new Button(parent, 0);
        newProjectButton.setText("New...");
    }

    private void createProviderEditor(Composite parent) {
        Label providerLabel = new Label(parent, 0);
        providerLabel.setText("Provider: ");
        final Text providerText = new Text(parent, 2048);
        providerText.setText("");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        providerText.setLayoutData((Object)gridData);
        providerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PersistenceSetupWizardPage.this.getWizardDescriptor().put(PersistenceSetupWizardPage.PROVIDER_NAME, providerText.getText());
            }
        });
        providerText.setText(defaultProvider);
    }

    private void createContainerEditor(Composite parent) {
        Label containerLabel = new Label(parent, 0);
        containerLabel.setText("Container: ");
        final Text containerText = new Text(parent, 2048);
        containerText.setText("");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        containerText.setLayoutData((Object)gridData);
        containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PersistenceSetupWizardPage.this.getWizardDescriptor().put(PersistenceSetupWizardPage.CONTAINER_NAME, containerText.getText());
            }
        });
        containerText.setText(defaultContainer);
    }
}

