/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.persistence;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.persistence.PersistenceSetupWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class PersistenceSetupWizard
extends AbstractForgeWizard {
    private PersistenceSetupWizardPage persistenceSetupWizardPage = new PersistenceSetupWizardPage();

    public PersistenceSetupWizard() {
        this.setWindowTitle("Set Up Persistence");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection sel) {
        super.init(workbench, sel);
        this.initializeProject(sel);
    }

    private void initializeProject(IStructuredSelection sel) {
        for (Object object : sel) {
            IProject project;
            if (!(object instanceof IResource) || WizardsHelper.isJPAProject(project = ((IResource)object).getProject())) continue;
            this.getWizardDescriptor().put("PersistenceSetupWizardPage.projectName", project.getName());
            return;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.persistenceSetupWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        this.sendRuntimeCommand("cd " + this.getProjectLocation(), monitor);
        this.sendRuntimeCommand("persistence setup --provider " + this.getProviderName() + " --container " + this.getContainerName(), monitor);
    }

    @Override
    protected int getAmountOfWorkExecute() {
        return 2;
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        IProject project = this.getProject(this.getProjectName());
        this.refreshResource((IResource)project, monitor);
        this.updateProjectConfiguration(project, monitor);
    }

    @Override
    protected int getAmountOfWorkRefresh() {
        return 2;
    }

    @Override
    public String getStatusMessage() {
        return "Setting up persistence for project '" + this.getProjectName() + "'.";
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("PersistenceSetupWizardPage.projectName");
    }

    private String getProviderName() {
        return (String)this.getWizardDescriptor().get("PersistenceSetupWizardPage.providerName");
    }

    private String getContainerName() {
        return (String)this.getWizardDescriptor().get("PersistenceSetupWizardPage.containerName");
    }

    private String getProjectLocation() {
        return this.getProject(this.getProjectName()).getLocation().toOSString();
    }
}

