/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.field;

import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.dialog.JPAProjectSelectionDialog;

public class NewFieldWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "NewFieldWizardPage.projectName";
    static final String ENTITY_NAME = "NewFieldWizardPage.entityName";
    static final String FIELD_NAME = "NewFieldWizardPage.fieldName";
    static final String FIELD_TYPE = "NewFieldWizardPage.fieldType";
    private static final String[] FIELD_TYPES = new String[]{"string", "int", "long", "number", "boolean", "temporal", "oneToOne", "oneToMany", "manyToOne", "manyToMany", "custom"};
    private Combo entityCombo;

    protected NewFieldWizardPage() {
        super("org.jboss.tools.forge.ui.wizard.field.new", "Create New Field", null);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        this.createProjectEditor(control);
        this.createEntityEditor(control);
        this.createNameEditor(control);
        this.createTypeEditor(control);
        this.setControl((Control)control);
    }

    private void createProjectEditor(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("Project: ");
        final Text projectNameText = new Text(parent, 2048);
        projectNameText.setText("");
        projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button projectSearchButton = new Button(parent, 0);
        projectSearchButton.setText("Search...");
        projectSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                JPAProjectSelectionDialog dialog = new JPAProjectSelectionDialog(NewFieldWizardPage.this.getShell());
                if (dialog.open() != 256) {
                    IProject project = (IProject)dialog.getResult()[0];
                    projectNameText.setText(project.getName());
                    NewFieldWizardPage.this.getWizardDescriptor().put(NewFieldWizardPage.PROJECT_NAME, project.getName());
                    NewFieldWizardPage.this.refreshEntityEditor(project);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void refreshEntityEditor(IProject project) {
        this.entityCombo.removeAll();
        JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
        Iterable iterable = jpaProject.getAnnotatedJavaSourceTypes();
        for (JavaResourceAbstractType jrat : iterable) {
            String qualifiedName = jrat.getTypeBinding().getQualifiedName();
            this.entityCombo.add(qualifiedName);
        }
    }

    private void createEntityEditor(Composite parent) {
        Label entityLabel = new Label(parent, 0);
        entityLabel.setText("Entity: ");
        this.entityCombo = new Combo(parent, 12);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.entityCombo.setLayoutData((Object)gridData);
        this.entityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFieldWizardPage.this.getWizardDescriptor().put(NewFieldWizardPage.ENTITY_NAME, NewFieldWizardPage.this.entityCombo.getText());
            }
        });
    }

    private void createNameEditor(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Field name: ");
        final Text nameText = new Text(parent, 2048);
        nameText.setText("");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        nameText.setLayoutData((Object)gridData);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFieldWizardPage.this.getWizardDescriptor().put(NewFieldWizardPage.FIELD_NAME, nameText.getText());
            }
        });
    }

    private void createTypeEditor(Composite parent) {
        Label typeLabel = new Label(parent, 0);
        typeLabel.setText("Field type: ");
        final Combo typeCombo = new Combo(parent, 12);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        typeCombo.setLayoutData((Object)gridData);
        String[] stringArray = FIELD_TYPES;
        int n = FIELD_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            typeCombo.add(type);
            ++n2;
        }
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFieldWizardPage.this.getWizardDescriptor().put(NewFieldWizardPage.FIELD_TYPE, typeCombo.getText());
            }
        });
    }
}

