/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.field;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.ui.wizards.internal.WizardsPlugin;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.field.NewFieldWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class NewFieldWizard
extends AbstractForgeWizard {
    private NewFieldWizardPage newFieldWizardPage = new NewFieldWizardPage();

    public NewFieldWizard() {
        this.setWindowTitle("Create New Field");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection sel) {
        super.init(workbench, sel);
        this.initializeProject(sel);
    }

    private void initializeProject(IStructuredSelection sel) {
        for (Object object : sel) {
            IProject project;
            if (!(object instanceof IResource) || !WizardsHelper.isJPAProject(project = ((IResource)object).getProject())) continue;
            this.getWizardDescriptor().put("NewFieldWizardPage.projectName", project.getName());
            return;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.newFieldWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        this.sendRuntimeCommand("pick-up " + this.getTargetEntityLocation(), monitor);
        this.sendRuntimeCommand("field " + this.getFieldType() + " --named " + this.getFieldName(), monitor);
    }

    @Override
    protected int getAmountOfWorkExecute() {
        return 2;
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        this.refreshResource(this.getTargetEntity().getResource(), monitor);
    }

    @Override
    public String getStatusMessage() {
        return "Creating new field '" + this.getFieldName() + "'.";
    }

    private IJavaElement getTargetEntity() {
        IJavaElement result = null;
        try {
            String entityName = this.getEntityName();
            entityName = String.valueOf(entityName.replace('.', '/')) + ".java";
            IProject project = this.getProject(this.getProjectName());
            IJavaProject javaProject = JavaCore.create((IProject)project);
            result = javaProject.findElement((IPath)new Path(entityName));
        }
        catch (JavaModelException e) {
            WizardsPlugin.log(e);
        }
        return result;
    }

    private String getTargetEntityLocation() {
        return this.getTargetEntity().getResource().getLocation().toOSString();
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("NewFieldWizardPage.projectName");
    }

    private String getEntityName() {
        return (String)this.getWizardDescriptor().get("NewFieldWizardPage.entityName");
    }

    private String getFieldName() {
        return (String)this.getWizardDescriptor().get("NewFieldWizardPage.fieldName");
    }

    private String getFieldType() {
        return (String)this.getWizardDescriptor().get("NewFieldWizardPage.fieldType");
    }
}

