/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.entity;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class NewEntityWizardPage
extends AbstractForgeWizardPage {
    static final String PROJECT_NAME = "NewEntityWizardPage.projectName";
    static final String ENTITY_NAME = "NewEntityWizardPage.entityName";

    protected NewEntityWizardPage() {
        super("org.jboss.tools.forge.ui.wizard.entity.new", "Create New Entity", null);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        this.createProjectEditor(control);
        this.createNameEditor(control);
        this.setControl((Control)control);
    }

    private void createProjectEditor(Composite parent) {
        IProject[] allProjects;
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText("Project: ");
        final Combo projectNameCombo = new Combo(parent, 12);
        projectNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WizardsHelper.isJPAProject(project)) {
                projectNameCombo.add(project.getName());
            }
            ++n2;
        }
        String projectName = (String)this.getWizardDescriptor().get(PROJECT_NAME);
        if (projectName != null) {
            projectNameCombo.setText(projectName);
        }
        projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEntityWizardPage.this.getWizardDescriptor().put(NewEntityWizardPage.PROJECT_NAME, projectNameCombo.getText());
            }
        });
        Button newProjectButton = new Button(parent, 0);
        newProjectButton.setText("New...");
    }

    private void createNameEditor(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Name: ");
        final Text nameText = new Text(parent, 2048);
        nameText.setText("");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        nameText.setLayoutData((Object)gridData);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewEntityWizardPage.this.getWizardDescriptor().put(NewEntityWizardPage.ENTITY_NAME, nameText.getText());
            }
        });
    }
}

