/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.entity;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.ui.wizards.internal.wizard.AbstractForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.entity.NewEntityWizardPage;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class NewEntityWizard
extends AbstractForgeWizard {
    private NewEntityWizardPage newEntityWizardPage = new NewEntityWizardPage();

    public NewEntityWizard() {
        this.setWindowTitle("Create New Entity");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection sel) {
        super.init(workbench, sel);
        this.initializeProject(sel);
    }

    private void initializeProject(IStructuredSelection sel) {
        for (Object object : sel) {
            IProject project;
            if (!(object instanceof IResource) || !WizardsHelper.isJPAProject(project = ((IResource)object).getProject())) continue;
            this.getWizardDescriptor().put("NewEntityWizardPage.projectName", project.getName());
            return;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.newEntityWizardPage);
    }

    @Override
    public void doExecute(IProgressMonitor monitor) {
        this.sendRuntimeCommand("cd " + this.getProjectLocation(), monitor);
        this.sendRuntimeCommand("entity --named " + this.getEntityName(), monitor);
    }

    @Override
    protected int getAmountOfWorkExecute() {
        return 2;
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        this.refreshResource((IResource)this.getProject(this.getProjectName()), monitor);
    }

    @Override
    public String getStatusMessage() {
        return "Creating new entity '" + this.getEntityName() + "'.";
    }

    private String getProjectName() {
        return (String)this.getWizardDescriptor().get("NewEntityWizardPage.projectName");
    }

    private String getEntityName() {
        return (String)this.getWizardDescriptor().get("NewEntityWizardPage.entityName");
    }

    private String getProjectLocation() {
        Object projectName = this.getWizardDescriptor().get("NewEntityWizardPage.projectName");
        IProject project = this.getProject((String)projectName);
        return project.getLocation().toOSString();
    }
}

