/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public class JPAProjectSelectionDialog
extends ListDialog
implements ISelectionChangedListener {
    Button check;

    public JPAProjectSelectionDialog(Shell parent) {
        super(parent);
        this.setTitle("JPA Projects");
        this.setMessage("Select JPA Project");
        this.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
        this.setInput(new Object());
        this.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<IProject> jpaProjects = new ArrayList<IProject>();
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isAccessible() && (JPAProjectSelectionDialog.this.check != null && JPAProjectSelectionDialog.this.check.getSelection() || WizardsHelper.isJPAProject(project))) {
                        jpaProjects.add(project);
                    }
                    ++n2;
                }
                return jpaProjects.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
        this.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getOkButton().setEnabled(!event.getSelection().isEmpty());
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.check = new Button(parent, 32);
        this.check.setText("Show all projects");
        this.check.setSelection(false);
        this.check.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableViewer v = JPAProjectSelectionDialog.this.getTableViewer();
                v.refresh();
            }
        });
        return parent;
    }
}

