/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.wizards.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.core.util.ProjectTools;
import org.jboss.tools.forge.ui.util.ForgeHelper;
import org.jboss.tools.forge.ui.wizards.internal.WizardsPlugin;
import org.jboss.tools.forge.ui.wizards.internal.wizard.IForgeWizard;
import org.jboss.tools.forge.ui.wizards.internal.wizard.util.WizardsHelper;

public abstract class AbstractForgeWizard
extends Wizard
implements IForgeWizard {
    private HashMap<Object, Object> wizardDescriptor = null;
    private String startDir = null;
    private boolean acceptDefaults = false;
    private ForgeRuntime runtime = WizardsHelper.getForgeRuntime();

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        try {
            if (ForgeRuntimeState.STOPPED.equals((Object)this.runtime.getState())) {
                this.startForge(this.runtime);
            }
        }
        catch (Exception e) {
            WizardsPlugin.log(e);
        }
    }

    private void startForge(final ForgeRuntime runtime) throws Exception {
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        pmd.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String taskName = "Please wait while Forge is starting";
                monitor.beginTask(taskName, -1);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ForgeHelper.start((ForgeRuntime)runtime);
                    }
                });
                while (!ForgeRuntimeState.RUNNING.equals((Object)runtime.getState())) {
                    taskName = String.valueOf(taskName) + ".";
                    monitor.setTaskName(taskName);
                    Thread.sleep(1000L);
                }
            }
        });
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(AbstractForgeWizard.this.getStatusMessage(), AbstractForgeWizard.this.getTotalAmountOfWork());
                    AbstractForgeWizard.this.before(monitor);
                    AbstractForgeWizard.this.execute(monitor);
                    AbstractForgeWizard.this.after(monitor);
                    AbstractForgeWizard.this.refresh(monitor);
                    monitor.done();
                }
            });
        }
        catch (Exception exception) {}
        return true;
    }

    protected int getTotalAmountOfWork() {
        return this.getAmountOfWorkBefore() + this.getAmountOfWorkExecute() + this.getAmountOfWorkAfter() + this.getAmountOfWorkRefresh();
    }

    protected void before(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.getAmountOfWorkBefore());
        subMonitor.beginTask("Preparing...", this.getAmountOfWorkBefore());
        subMonitor.setTaskName("Preparing...");
        this.doBefore((IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    protected void execute(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.getAmountOfWorkExecute());
        subMonitor.beginTask("Executing...", this.getAmountOfWorkExecute());
        subMonitor.setTaskName("Executing...");
        this.doExecute((IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    protected void after(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.getAmountOfWorkAfter());
        subMonitor.beginTask("Cleaning up...", this.getAmountOfWorkAfter());
        subMonitor.setTaskName("Cleaning up...");
        this.doAfter((IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    protected void refresh(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.getAmountOfWorkRefresh());
        subMonitor.beginTask("Refreshing...", this.getAmountOfWorkRefresh());
        subMonitor.setTaskName("Refreshing...");
        this.doRefresh((IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    protected String sendRuntimeCommand(String command, IProgressMonitor monitor) {
        monitor.setTaskName("Executing '" + command + "'");
        String result = this.getRuntime().sendCommand(command);
        monitor.worked(1);
        return result;
    }

    protected void doBefore(IProgressMonitor monitor) {
        this.startDir = this.sendRuntimeCommand("pwd", monitor).trim();
        this.acceptDefaults = false;
        String variables = this.sendRuntimeCommand("set", monitor);
        int start = variables.indexOf("ACCEPT_DEFAULTS=");
        if (start != -1) {
            int end = variables.indexOf(10, start += "ACCEPT_DEFAULTS=".length());
            this.acceptDefaults = end > start && "true".equals(variables.substring(start, end));
        }
        this.sendRuntimeCommand("set ACCEPT_DEFAULTS true", monitor);
    }

    protected int getAmountOfWorkBefore() {
        return 3;
    }

    protected void doAfter(IProgressMonitor monitor) {
        this.sendRuntimeCommand("cd " + this.startDir, monitor);
        this.sendRuntimeCommand("set ACCEPT_DEFAULTS " + (this.acceptDefaults ? "true" : "false"), monitor);
    }

    protected int getAmountOfWorkAfter() {
        return 2;
    }

    protected int getAmountOfWorkExecute() {
        return 1;
    }

    protected int getAmountOfWorkRefresh() {
        return 1;
    }

    protected IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    protected void refreshResource(IResource project, IProgressMonitor monitor) {
        try {
            monitor.setTaskName("Refreshing resource " + project.getName());
            project.refreshLocal(2, null);
            monitor.worked(1);
        }
        catch (CoreException e) {
            WizardsPlugin.log(e);
        }
    }

    protected void updateProjectConfiguration(IProject project, IProgressMonitor monitor) {
        monitor.setTaskName("Updating configuration of project " + project.getName());
        ProjectTools.updateProjectConfiguration((IProject)project);
        monitor.worked(1);
    }

    @Override
    public Map<Object, Object> getWizardDescriptor() {
        if (this.wizardDescriptor == null) {
            this.wizardDescriptor = new HashMap();
        }
        return this.wizardDescriptor;
    }

    @Override
    public ForgeRuntime getRuntime() {
        return this.runtime;
    }
}

