/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.internal.discovery.MavenDiscovery;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.m2e.internal.discovery.wizards.MavenCatalogConfiguration;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenCatalogViewer
extends CatalogViewer {
    public static final Logger log = LoggerFactory.getLogger(MavenCatalogViewer.class);
    private static final String CONFIGURATOR_PREFIX = "configurator:";
    private static final String LIFECYCLE_PREFIX = "lifecycle:";
    private Set<String> installedFeatures;
    private boolean noneApplicable;

    public MavenCatalogViewer(Catalog catalog, IShellProvider shellProvider, IRunnableContext context, CatalogConfiguration configuration) {
        super(catalog, shellProvider, context, configuration);
    }

    protected void postDiscovery(IProgressMonitor monitor) {
        final SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.getCatalog().getItems().size() * 3));
        try {
            for (CatalogItem connector : this.getCatalog().getItems()) {
                connector.setInstalled(this.installedFeatures != null && this.installedFeatures.containsAll(connector.getInstallableUnits()));
                subMon.worked(1);
            }
            if (this.getCatalog().getItems().size() == this.installedFeatures.size()) {
                this.handleStatus((IStatus)new Status(4, "org.eclipse.m2e.discovery", Messages.MavenCatalogViewer_allInstalled));
            } else {
                MavenCatalogConfiguration config = (MavenCatalogConfiguration)this.getConfiguration();
                final Collection<String> selectedPackagingTypes = config.getSelectedPackagingTypes();
                final Collection<MojoExecutionKey> selectedMojos = config.getSelectedMojos();
                final Collection<String> selectedLifecycleIds = config.getSelectedLifecycleIds();
                final Collection<String> selectedConfiguratorIds = config.getSelectedConfiguratorIds();
                if (!(selectedConfiguratorIds.isEmpty() && selectedLifecycleIds.isEmpty() && selectedMojos.isEmpty() && selectedPackagingTypes.isEmpty())) {
                    this.noneApplicable = true;
                    this.shellProvider.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            block0: for (CatalogItem ci : MavenCatalogViewer.this.getCatalog().getItems()) {
                                boolean selected = false;
                                subMon.worked(2);
                                LifecycleMappingMetadataSource src = MavenDiscovery.getLifecycleMappingMetadataSource(ci);
                                if (src != null) {
                                    for (String packagingType : selectedPackagingTypes) {
                                        if (!MavenCatalogViewer.hasPackaging(src, packagingType)) continue;
                                        selected = true;
                                        MavenCatalogViewer.this.select(ci);
                                        break;
                                    }
                                    if (selected) continue;
                                    for (MojoExecutionKey mojoExecution : selectedMojos) {
                                        if (!MavenCatalogViewer.matchesFilter(src, mojoExecution)) continue;
                                        selected = true;
                                        MavenCatalogViewer.this.select(ci);
                                        break;
                                    }
                                    if (selected) continue;
                                }
                                for (String configuratorId : selectedConfiguratorIds) {
                                    Tag configuratorIdTag = new Tag(MavenCatalogViewer.CONFIGURATOR_PREFIX + configuratorId, MavenCatalogViewer.CONFIGURATOR_PREFIX + configuratorId);
                                    if (!ci.hasTag(configuratorIdTag)) continue;
                                    selected = true;
                                    MavenCatalogViewer.this.select(ci);
                                    break;
                                }
                                if (selected) continue;
                                for (String lifecycleId : selectedLifecycleIds) {
                                    Tag lifecycleIdTag = new Tag(MavenCatalogViewer.LIFECYCLE_PREFIX + lifecycleId, MavenCatalogViewer.LIFECYCLE_PREFIX + lifecycleId);
                                    if (!ci.hasTag(lifecycleIdTag)) continue;
                                    MavenCatalogViewer.this.select(ci);
                                    continue block0;
                                }
                            }
                            if (MavenCatalogViewer.this.noneApplicable) {
                                MavenCatalogViewer.this.handleStatus((IStatus)new Status(4, "org.eclipse.m2e.discovery", Messages.MavenCatalogViewer_noApplicableMarketplaceItems));
                            }
                        }
                    });
                }
            }
        }
        finally {
            subMon.done();
        }
    }

    public void updateCatalog() {
        boolean wasCancelled = false;
        boolean wasError = false;
        final IStatus[] result = new IStatus[1];
        try {
            this.context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        if (MavenCatalogViewer.this.installedFeatures == null) {
                            MavenCatalogViewer.this.installedFeatures = MavenCatalogViewer.this.getInstalledFeatures((IProgressMonitor)submon.newChild(10));
                        }
                        result[0] = MavenCatalogViewer.this.getCatalog().performDiscovery((IProgressMonitor)submon.newChild(80));
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (!MavenCatalogViewer.this.getCatalog().getItems().isEmpty()) {
                            MavenCatalogViewer.this.postDiscovery((IProgressMonitor)submon.newChild(10));
                        }
                    }
                    finally {
                        submon.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            result[0] = this.computeStatus(e, Messages.MavenCatalogViewer_unexpectedException);
        }
        catch (InterruptedException interruptedException) {
            wasCancelled = true;
        }
        if (result[0] != null && !result[0].isOK()) {
            this.handleStatus(result[0]);
            wasError = true;
        }
        if (this.getCatalog() != null) {
            this.catalogUpdated(wasCancelled, wasError);
            this.verifyUpdateSiteAvailability();
        }
        this.viewer.setData("discoveryComplete", (Object)Boolean.TRUE);
    }

    private void select(CatalogItem ci) {
        this.modifySelection(ci, true);
        ci.addTag(MavenDiscovery.APPLICABLE_TAG);
        this.noneApplicable = false;
    }

    private void handleStatus(final IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.shellProvider instanceof WizardPage) {
            this.shellProvider.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int messageType = 1;
                    if (status.matches(4)) {
                        messageType = 3;
                    } else if (status.matches(2)) {
                        messageType = 2;
                    }
                    ((WizardPage)MavenCatalogViewer.this.shellProvider).setMessage(status.getMessage(), messageType);
                    StatusManager.getManager().handle(status);
                }
            });
        } else {
            StatusManager.getManager().handle(status, 7);
        }
    }

    private static boolean matchesFilter(LifecycleMappingMetadataSource src, MojoExecutionKey mojoExecution) {
        for (PluginExecutionMetadata p : src.getPluginExecutions()) {
            if (!p.getFilter().match(mojoExecution)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPackaging(LifecycleMappingMetadataSource lifecycleMappingMetadataSource, String packagingType) {
        for (LifecycleMappingMetadata lifecycleMappingMetadata : lifecycleMappingMetadataSource.getLifecycleMappings()) {
            if (!packagingType.equals(lifecycleMappingMetadata.getPackagingType())) continue;
            return true;
        }
        return false;
    }
}

