/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.resref.core.ResourceReferenceList;
import org.jboss.tools.vpe.resref.core.Messages;

public abstract class FolderReferenceComposite {
    private Text pathText = null;
    Object fileLocation = null;
    private ResourceReference defaultReference;
    List<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
    private ResourceReference currentReference;
    private boolean overrideDefaultPath;
    private Combo scopeCombo = null;
    private static final String[] scopeNames = new String[]{Messages.SCOPE_PAGE_SHORT, Messages.SCOPE_FOLDER_SHORT, Messages.SCOPE_PROJECT_SHORT};
    private static final int[] scopeValues;
    private Button browseButton;
    private Button overrideDefaultPathCheckBox;
    private Label pathLabel;
    private Label scopeLabel;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        scopeValues = nArray;
    }

    public void setObject(Object fileLocation, ResourceReference defaultReference) {
        this.defaultReference = defaultReference;
        this.fileLocation = fileLocation;
        if (fileLocation instanceof IFile) {
            this.resourceReferences.addAll(Arrays.asList(this.getReferenceList().getAllResources((IFile)fileLocation)));
        } else if (fileLocation instanceof IPath) {
            this.resourceReferences.addAll(Arrays.asList(this.getReferenceList().getAllResources((IPath)fileLocation)));
        }
        if (this.resourceReferences.size() != 0) {
            this.overrideDefaultPath = true;
            ResourceReference firstReference = this.resourceReferences.remove(0);
            this.currentReference = new ResourceReference(firstReference.getLocation(), firstReference.getScope());
        } else {
            this.overrideDefaultPath = false;
            this.currentReference = new ResourceReference(defaultReference.getLocation(), defaultReference.getScope());
        }
    }

    protected abstract ResourceReferenceList getReferenceList();

    protected abstract String getTitle();

    public Control createControl(Composite parent) {
        Group groupControl = new Group(parent, 16);
        GridData gd = new GridData(4, 4, true, true);
        GridLayout layout = new GridLayout(3, false);
        groupControl.setLayout((Layout)layout);
        groupControl.setLayoutData((Object)gd);
        groupControl.setText(this.getTitle());
        this.overrideDefaultPathCheckBox = new Button((Composite)groupControl, 16416);
        this.overrideDefaultPathCheckBox.setText(Messages.OVERRIDE_DEFAULT_FOLDER);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.overrideDefaultPathCheckBox.setLayoutData((Object)gd);
        this.overrideDefaultPathCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderReferenceComposite.this.overrideDefaultPath = FolderReferenceComposite.this.overrideDefaultPathCheckBox.getSelection();
                FolderReferenceComposite.this.updateFieldsForOverrideDefaultPath();
            }
        });
        this.overrideDefaultPathCheckBox.setSelection(this.overrideDefaultPath);
        this.pathLabel = new Label((Composite)groupControl, 131072);
        this.pathLabel.setText(Messages.FOLDER_PATH);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.pathLabel.setLayoutData((Object)gd);
        this.pathText = new Text((Composite)groupControl, 2048);
        this.pathText.setText(this.currentReference.getLocation());
        gd = new GridData(4, 0, true, false);
        this.pathText.setLayoutData((Object)gd);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderReferenceComposite.this.currentReference.setLocation(FolderReferenceComposite.this.pathText.getText().trim());
            }
        });
        this.browseButton = new Button((Composite)groupControl, 8);
        this.browseButton.setText(Messages.BROWSE_BUTTON_NAME);
        gd = new GridData();
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String newPath;
                DirectoryDialog dialog = new DirectoryDialog(FolderReferenceComposite.this.browseButton.getShell());
                dialog.setMessage(Messages.SELECT_FOLDER_DIALOG_TITLE);
                if (new File(FolderReferenceComposite.this.currentReference.getLocation()).exists()) {
                    dialog.setFilterPath(FolderReferenceComposite.this.currentReference.getLocation());
                }
                if ((newPath = dialog.open()) != null) {
                    FolderReferenceComposite.this.currentReference.setLocation(newPath.trim());
                    FolderReferenceComposite.this.pathText.setText(FolderReferenceComposite.this.currentReference.getLocation());
                }
            }
        });
        this.scopeLabel = new Label((Composite)groupControl, 131072);
        this.scopeLabel.setText(Messages.SCOPE_GROUP_NAME);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.scopeLabel.setLayoutData((Object)gd);
        this.scopeCombo = new Combo((Composite)groupControl, 2056);
        this.scopeCombo.setItems(scopeNames);
        this.setScopeComboValue(this.currentReference.getScope());
        gd = new GridData(4, 0, true, false, 2, 1);
        this.scopeCombo.setLayoutData((Object)gd);
        this.scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderReferenceComposite.this.currentReference.setScope(FolderReferenceComposite.this.getScopeComboValue());
            }
        });
        this.updateFieldsForOverrideDefaultPath();
        return groupControl;
    }

    public void commit() {
        ArrayList<ResourceReference> newResourceReferencesList = new ArrayList<ResourceReference>();
        int i = this.resourceReferences.size() - 1;
        while (i >= 0) {
            if (!this.resourceReferences.get(i).getLocation().equals(this.currentReference.getLocation()) && this.resourceReferences.get(i).getScope() != this.currentReference.getScope()) {
                newResourceReferencesList.add(this.resourceReferences.get(i));
            }
            --i;
        }
        if (this.overrideDefaultPath) {
            newResourceReferencesList.add(this.currentReference);
        }
        ResourceReference[] newResourceReferences = newResourceReferencesList.toArray(new ResourceReference[0]);
        if (this.fileLocation instanceof IFile) {
            this.getReferenceList().setAllResources((IFile)this.fileLocation, newResourceReferences);
        } else if (this.fileLocation instanceof IPath) {
            this.getReferenceList().setAllResources((IPath)this.fileLocation, newResourceReferences);
        }
    }

    private int getScopeComboValue() {
        return scopeValues[this.scopeCombo.getSelectionIndex()];
    }

    private void setScopeComboValue(int value) {
        int i = 0;
        int[] nArray = scopeValues;
        int n = scopeValues.length;
        int n2 = 0;
        while (n2 < n) {
            int scopeValue = nArray[n2];
            if (scopeValue == value) break;
            ++i;
            ++n2;
        }
        this.scopeCombo.select(i);
    }

    private void updateFieldsForOverrideDefaultPath() {
        this.pathText.setEditable(this.overrideDefaultPath);
        Control[] controlArray = new Control[]{this.pathLabel, this.browseButton, this.scopeLabel, this.scopeCombo};
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(this.overrideDefaultPath);
            ++n2;
        }
        if (!this.overrideDefaultPath) {
            this.pathText.setText(this.defaultReference.getLocation());
            this.setScopeComboValue(this.defaultReference.getScope());
        }
    }
}

