/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.ui.views.TreeObject;
import org.eclipse.bpmn2.modeler.ui.views.TreeParent;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewSite;

class ViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private TreeParent invisibleRoot;

    ViewContentProvider() {
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof IViewSite) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).hasChildren();
        }
        return false;
    }

    private void initialize() {
        this.invisibleRoot = new TreeParent("");
    }

    void updateModel(ModelHandler mh) {
        this.invisibleRoot.removeChildren();
        if (mh == null) {
            return;
        }
        Definitions definitions = mh.getDefinitions();
        List rootElements = definitions.getRootElements();
        for (RootElement element : rootElements) {
            if (!(element instanceof Process)) continue;
            Process process = (Process)element;
            TreeParent proc = new TreeParent("Process");
            this.createLaneSets(proc, process.getLaneSets());
            this.createFlowElementTree(proc, process.getFlowElements());
            this.invisibleRoot.addChild(proc);
        }
    }

    private void createLaneSets(TreeParent proc, List<LaneSet> laneSets) {
        for (LaneSet laneSet : laneSets) {
            this.createLaneSetTree(proc, laneSet);
        }
    }

    private void createLaneSetTree(TreeParent proc, LaneSet laneSet) {
        if (laneSet == null) {
            return;
        }
        for (Lane lane : laneSet.getLanes()) {
            TreeParent parent = new TreeParent((BaseElement)lane);
            proc.addChild(parent);
            this.createLaneSetTree(parent, lane.getChildLaneSet());
        }
    }

    private void createFlowElementTree(TreeParent proc, List<FlowElement> flowElements) {
        for (FlowElement f : flowElements) {
            if (f instanceof SequenceFlow) continue;
            TreeObject treeObject = new TreeObject((BaseElement)f);
            proc.addChild(treeObject);
        }
    }

    public Object[] getSelected(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            List<Object> selected = Arrays.asList(sel.toArray());
            if (selected.size() == 0 || !(selected.get(0) instanceof ContainerShapeEditPart)) {
                return null;
            }
            PictogramLink link = ((ContainerShapeEditPart)selected.get(0)).getPictogramElement().getLink();
            if (link == null) {
                return null;
            }
            EList businessObjects = link.getBusinessObjects();
            TreeObject[] children = this.invisibleRoot.getChildren();
            ArrayList<TreeObject> list = this.getSelectionFromList((EList<EObject>)businessObjects, children);
            return list.toArray();
        }
        return null;
    }

    private ArrayList<TreeObject> getSelectionFromList(EList<EObject> businessObjects, TreeObject[] children) {
        ArrayList<TreeObject> list = new ArrayList<TreeObject>();
        TreeObject[] treeObjectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject treeObject = treeObjectArray[n2];
            if (treeObject instanceof TreeParent) {
                if (businessObjects.contains((Object)treeObject.getBaseElement())) {
                    list.add(treeObject);
                }
                list.addAll(this.getSelectionFromList(businessObjects, ((TreeParent)treeObject).getChildren()));
            } else if (businessObjects.contains((Object)treeObject.getBaseElement())) {
                list.add(treeObject);
            }
            ++n2;
        }
        return list;
    }
}

