/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import java.util.List;
import org.eclipse.bpmn2.modeler.ui.property.providers.CompositeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.ITreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaMemberContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaMemberTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaTypeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaTypeTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.ModelTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.util.ListMap;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;

public class JavaTreeContentProvider
extends ModelTreeContentProvider {
    boolean isPropertyTree;
    private CompositeContentProvider fContentProvider = new CompositeContentProvider();

    public JavaTreeContentProvider(boolean isCondensed) {
        super(isCondensed);
        this.fContentProvider.add(new JavaTypeContentProvider());
        this.fContentProvider.add(new JavaMemberContentProvider());
    }

    public boolean isPropertyTree() {
        return this.isPropertyTree;
    }

    @Override
    public Object[] primGetElements(Object inputElement) {
        ITreeNode result = this.getTreeNode(inputElement);
        if (result != null) {
            return new Object[]{result};
        }
        if (inputElement instanceof List) {
            Object[] elements = this.fContentProvider.getElements(inputElement);
            ListMap.Visitor visitor = new ListMap.Visitor(){

                @Override
                public Object visit(Object obj) {
                    ITreeNode r = JavaTreeContentProvider.this.getTreeNode(obj);
                    return r == null ? ListMap.IGNORE : r;
                }
            };
            return (Object[])ListMap.Map(elements, visitor, EMPTY_ARRAY);
        }
        return EMPTY_ARRAY;
    }

    ITreeNode getTreeNode(Object inputElement) {
        if (inputElement instanceof IType) {
            return new JavaTypeTreeNode(inputElement, this.isCondensed);
        }
        if (inputElement instanceof IMember) {
            return new JavaMemberTreeNode(inputElement, this.isCondensed);
        }
        return null;
    }
}

