/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.editors;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.property.editors.Messages;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ServiceImplementationObjectEditor
extends ComboObjectEditor {
    public static String UNSPECIFIED_LABEL = Messages.ServiceImplementationObjectEditor_Unspecified_Label;
    public static String UNSPECIFIED_VALUE = "##unspecified";
    public static String WEBSERVICE_LABEL = Messages.ServiceImplementationObjectEditor_Web_Service_Label;
    public static String WEBSERVICE_VALUE = "##WebService";

    public ServiceImplementationObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    public ServiceImplementationObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature, EClass featureEType) {
        super(parent, object, feature, featureEType);
    }

    protected boolean canEdit() {
        if (this.editButton == null) {
            return true;
        }
        Object value = this.object.eGet(this.feature);
        return !(value instanceof String) || !((String)value).startsWith("##");
    }

    protected boolean canCreateNew() {
        return true;
    }

    public boolean setValue(Object result) {
        if (ModelUtil.isStringWrapper((Object)result)) {
            result = ModelUtil.getStringWrapperValue((Object)result);
        }
        return super.setValue(result);
    }

    public Object getValue() {
        Object value = this.object.eGet(this.feature);
        if (UNSPECIFIED_VALUE.equals(value)) {
            value = UNSPECIFIED_LABEL;
        } else if (WEBSERVICE_VALUE.equals(value)) {
            value = WEBSERVICE_LABEL;
        }
        return value;
    }

    protected EObject createObject() throws Exception {
        Hashtable<String, Object> choices = this.getChoiceOfValues(this.object, this.feature);
        ImplementationEditingDialog dialog = new ImplementationEditingDialog(this.getDiagramEditor().getEditorSite().getShell(), Messages.ServiceImplementationObjectEditor_Create_New_Title, choices, null);
        if (dialog.open() == 0) {
            return ModelUtil.createStringWrapper((String)dialog.getValue());
        }
        throw new OperationCanceledException(Messages.ServiceImplementationObjectEditor_Dialog_Cancelled);
    }

    protected EObject editObject(EObject value) throws Exception {
        String newValue;
        Hashtable<String, Object> choices = this.getChoiceOfValues(this.object, this.feature);
        final String oldValue = ModelUtil.getStringWrapperValue((Object)value);
        ImplementationEditingDialog dialog = new ImplementationEditingDialog(this.getDiagramEditor().getEditorSite().getShell(), Messages.ServiceImplementationObjectEditor_Edit_Title, choices, oldValue);
        if (dialog.open() == 0 && !(newValue = dialog.getValue()).equals(value)) {
            final Definitions definitions = ModelUtil.getDefinitions((EObject)this.object);
            if (definitions != null) {
                TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        TreeIterator iter = definitions.eAllContents();
                        while (iter.hasNext()) {
                            String implementation;
                            EObject o = (EObject)iter.next();
                            EStructuralFeature f = o.eClass().getEStructuralFeature("implementation");
                            if (f == null || !oldValue.equals(implementation = (String)o.eGet(f))) continue;
                            o.eSet(f, (Object)newValue);
                        }
                    }
                });
            }
            return ModelUtil.createStringWrapper((String)dialog.getValue());
        }
        throw new OperationCanceledException(Messages.ServiceImplementationObjectEditor_Dialog_Cancelled);
    }

    protected Hashtable<String, Object> getChoiceOfValues(EObject object, EStructuralFeature feature) {
        Definitions definitions;
        Hashtable<String, Object> choices = new Hashtable<String, Object>();
        choices.put(UNSPECIFIED_LABEL, ModelUtil.createStringWrapper((String)UNSPECIFIED_VALUE));
        choices.put(WEBSERVICE_LABEL, ModelUtil.createStringWrapper((String)WEBSERVICE_VALUE));
        Hashtable otherChoices = ModelUtil.getChoiceOfValues((EObject)object, (EStructuralFeature)feature);
        if (otherChoices != null) {
            choices.putAll(otherChoices);
        }
        if ((definitions = ModelUtil.getDefinitions((EObject)object)) != null) {
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                String implementation;
                EObject o = (EObject)iter.next();
                EStructuralFeature f = o.eClass().getEStructuralFeature("implementation");
                if (f == null || (implementation = (String)o.eGet(f)) == null || implementation.isEmpty() || implementation.startsWith("##") || choices.containsKey(implementation)) continue;
                choices.put(implementation, ModelUtil.createStringWrapper((String)implementation));
            }
        }
        return choices;
    }

    public class ImplementationEditingDialog
    extends InputDialog {
        public ImplementationEditingDialog(Shell shell, String title, final Map<String, Object> choices, final String uriString) {
            super(shell, title, Messages.ServiceImplementationObjectEditor_Implementation_Title, uriString, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return Messages.ServiceImplementationObjectEditor_Invalid_Empty;
                    }
                    if (newText.equals(uriString)) {
                        return null;
                    }
                    if (choices.containsKey(newText) || choices.containsValue(newText)) {
                        return NLS.bind((String)Messages.ServiceImplementationObjectEditor_Invalid_Duplicate, (Object)newText);
                    }
                    URI uri = URI.createURI((String)newText);
                    if (!uri.hasAuthority() || uri.scheme() == null) {
                        return Messages.ServiceImplementationObjectEditor_Invalid_URI;
                    }
                    return null;
                }
            });
        }
    }
}

