/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.editors;

import javax.xml.namespace.QName;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.SchemaSelectionDialog;
import org.eclipse.bpmn2.modeler.ui.property.editors.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class SchemaObjectEditor
extends TextAndButtonObjectEditor {
    protected Resource resource = BPMN2Editor.getActiveEditor().getModelHandler().getResource();
    protected Import imp;
    protected Button editButton;

    public SchemaObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    protected Control createControl(Composite composite, String label, int style) {
        super.createControl(composite, label, style);
        this.text.setEditable(true);
        this.defaultButton.setText(Messages.SchemaObjectEditor_Browse_Button);
        return this.text;
    }

    protected void buttonClicked(int buttonId) {
        SchemaSelectionDialog dialog = new SchemaSelectionDialog(this.parent.getShell(), this.object);
        if (dialog.open() == 0) {
            String prefix;
            String ns;
            XSDSchema schema;
            String prefix2;
            QName qname;
            Object result = dialog.getResult()[0];
            String selectionPath = dialog.getSelectionPath();
            String value = "";
            String selectionType = "";
            if (result instanceof PortType) {
                PortType portType = (PortType)result;
                qname = portType.getQName();
                prefix2 = NamespaceUtil.getPrefixForNamespace((Resource)this.resource, (String)qname.getNamespaceURI());
                if (prefix2 == null) {
                    prefix2 = NamespaceUtil.addNamespace((Resource)this.resource, (String)qname.getNamespaceURI());
                }
                if (prefix2 != null) {
                    value = String.valueOf(prefix2) + ":";
                }
                value = String.valueOf(value) + qname.getLocalPart();
                selectionType = Messages.SchemaObjectEditor_WSDL_Port;
            }
            if (result instanceof Operation) {
                selectionType = Messages.SchemaObjectEditor_WSDL_Operation;
            }
            if (result instanceof Input) {
                Input input = (Input)result;
                result = input.getMessage();
                selectionType = Messages.SchemaObjectEditor_WSDL_Input;
            }
            if (result instanceof Output) {
                Output output = (Output)result;
                result = output.getMessage();
                selectionType = Messages.SchemaObjectEditor_WSDL_Output;
            }
            if (result instanceof Fault) {
                Fault fault = (Fault)result;
                result = fault.getMessage();
                selectionType = Messages.SchemaObjectEditor_WSDL_Fault;
            }
            if (result instanceof Part) {
                Part part = (Part)result;
                result = part.getElementDeclaration();
                selectionType = Messages.SchemaObjectEditor_WSDL_Message_Part;
            }
            if (result instanceof Message) {
                Message message = (Message)result;
                qname = message.getQName();
                prefix2 = NamespaceUtil.getPrefixForNamespace((Resource)this.resource, (String)qname.getNamespaceURI());
                if (prefix2 == null) {
                    prefix2 = NamespaceUtil.addNamespace((Resource)this.resource, (String)qname.getNamespaceURI());
                }
                if (prefix2 != null) {
                    value = String.valueOf(prefix2) + ":";
                }
                value = String.valueOf(value) + qname.getLocalPart();
                selectionType = Messages.SchemaObjectEditor_WSDL_Message;
            }
            if (result instanceof XSDAttributeDeclaration) {
                selectionType = Messages.SchemaObjectEditor_XML_Attribute;
            }
            if (result instanceof XSDElementDeclaration) {
                XSDTypeDefinition type;
                XSDElementDeclaration decl = (XSDElementDeclaration)result;
                schema = this.getContainingSchema((EObject)decl);
                ns = schema.getTargetNamespace();
                if (ns == null && (type = decl.getTypeDefinition()) != null) {
                    ns = type.getSchema().getTargetNamespace();
                }
                if ((prefix = NamespaceUtil.getPrefixForNamespace((Resource)this.resource, (String)ns)) != null) {
                    value = String.valueOf(prefix) + ":";
                }
                value = String.valueOf(value) + selectionPath;
            }
            if (result instanceof XSDTypeDefinition) {
                XSDTypeDefinition type = (XSDTypeDefinition)result;
                schema = this.getContainingSchema((EObject)type);
                ns = schema.getTargetNamespace();
                prefix = NamespaceUtil.getPrefixForNamespace((Resource)this.resource, (String)ns);
                if (prefix != null) {
                    value = String.valueOf(prefix) + ":";
                }
                value = String.valueOf(value) + selectionPath;
            }
            if (result instanceof XSDSchema) {
                XSDSchema schema2 = (XSDSchema)result;
                String prefix3 = NamespaceUtil.getPrefixForNamespace((Resource)this.resource, (String)schema2.getTargetNamespace());
                if (prefix3 != null) {
                    value = String.valueOf(prefix3) + ":";
                }
                value = String.valueOf(value) + "schema";
            }
            if (result instanceof Process) {
                Process process = (Process)result;
                process.getSupportedInterfaceRefs();
            }
            if (result instanceof IType) {
                value = ((IType)result).getFullyQualifiedName('.');
            }
            if (value.isEmpty()) {
                MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.SchemaObjectEditor_Invalid_Selection_Title, (String)NLS.bind((String)Messages.SchemaObjectEditor_Invalid_Selection_Message, (Object)selectionType));
            } else {
                this.setValue(value);
            }
        }
    }

    private XSDSchema getContainingSchema(EObject object) {
        EObject container = object.eContainer();
        if (container instanceof XSDSchema) {
            return (XSDSchema)container;
        }
        if (container != null) {
            return this.getContainingSchema(container);
        }
        return null;
    }
}

