/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablementTreeEntry;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ModelEnablementTreeViewer
extends Composite {
    private Group group;
    private Tree tree;
    private CheckboxTreeViewer treeViewer;

    public ModelEnablementTreeViewer(Composite parent, String name) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.group = new Group((Composite)this, 0);
        this.group.setText(name);
        GridData data = new GridData(4, 128, true, true, 1, 1);
        data.heightHint = 100;
        data.widthHint = 50;
        this.group.setLayoutData((Object)data);
        this.group.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new CheckboxTreeViewer((Composite)this.group, 2048);
        this.tree = this.treeViewer.getTree();
        data = new GridData(4, 128, true, true, 1, 1);
        data.heightHint = 100;
        data.widthHint = 50;
        this.tree.setLayoutData((Object)data);
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof ModelEnablementTreeEntry) {
                    ModelEnablementTreeEntry entry = (ModelEnablementTreeEntry)element;
                    if (entry.getChildren().size() > 0) {
                        for (ModelEnablementTreeEntry child : entry.getChildren()) {
                            if (!child.getEnabled().booleanValue()) continue;
                            return true;
                        }
                        return false;
                    }
                    return entry.getEnabled();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                if (element instanceof ModelEnablementTreeEntry) {
                    ModelEnablementTreeEntry entry = (ModelEnablementTreeEntry)element;
                    int countEnabled = 0;
                    for (ModelEnablementTreeEntry child : entry.getChildren()) {
                        if (!child.getEnabled().booleanValue()) continue;
                        ++countEnabled;
                    }
                    return countEnabled > 0 && countEnabled != entry.getChildren().size();
                }
                return false;
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridData gd = (GridData)ModelEnablementTreeViewer.this.tree.getLayoutData();
                gd.heightHint = 1000;
                gd = (GridData)ModelEnablementTreeViewer.this.group.getLayoutData();
                gd.heightHint = 1000;
                ModelEnablementTreeViewer.this.group.layout();
                ModelEnablementTreeViewer.this.layout();
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                Object element = event.getElement();
                if (element instanceof ModelEnablementTreeEntry) {
                    ModelEnablementTreeEntry entry = (ModelEnablementTreeEntry)element;
                    this.updateDescendents(entry, checked);
                    this.updateAncestors(entry.getParent(), checked);
                }
            }

            void updateDescendents(ModelEnablementTreeEntry entry, boolean checked) {
                for (ModelEnablementTreeEntry child : entry.getChildren()) {
                    this.updateDescendents(child, checked);
                }
                entry.setSubtreeEnabled(Boolean.valueOf(checked));
                ModelEnablementTreeViewer.this.treeViewer.setSubtreeChecked((Object)entry, checked);
                ModelEnablementTreeViewer.this.treeViewer.setChecked((Object)entry, checked);
                ModelEnablementTreeViewer.this.treeViewer.setGrayed((Object)entry, false);
                for (ModelEnablementTreeEntry friend : entry.getFriends()) {
                    this.updateAncestors(friend, checked);
                    if (friend.getParent() == null) continue;
                    this.updateAncestors(friend.getParent(), checked);
                }
                for (ModelEnablementTreeEntry child : entry.getChildren()) {
                    for (ModelEnablementTreeEntry friend : child.getFriends()) {
                        if (child.getParent() != null) {
                            this.updateAncestors(child.getParent(), checked);
                        }
                        this.updateAncestors(friend, checked);
                    }
                }
            }

            void updateAncestors(ModelEnablementTreeEntry entry, boolean checked) {
                while (entry != null) {
                    int enabled = entry.getSubtreeEnabledCount();
                    int size = entry.getSubtreeEnabledCount();
                    if (enabled == 0) {
                        ModelEnablementTreeViewer.this.treeViewer.setChecked((Object)entry, false);
                        entry.setEnabled(Boolean.valueOf(false));
                        checked = true;
                    } else if (enabled == size) {
                        ModelEnablementTreeViewer.this.treeViewer.setChecked((Object)entry, true);
                        ModelEnablementTreeViewer.this.treeViewer.setGrayed((Object)entry, false);
                        entry.setEnabled(Boolean.valueOf(true));
                    } else {
                        ModelEnablementTreeViewer.this.treeViewer.setGrayChecked((Object)entry, true);
                        entry.setEnabled(Boolean.valueOf(true));
                    }
                    for (ModelEnablementTreeEntry friend : entry.getFriends()) {
                        this.updateAncestors(friend, checked);
                    }
                    this.refreshSiblings(entry);
                    entry = entry.getParent();
                }
            }

            private void refreshSiblings(Object element) {
                Control[] kids;
                Control[] controlArray = kids = ModelEnablementTreeViewer.this.getParent().getChildren();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    Control k = controlArray[n2];
                    if (k instanceof ModelEnablementTreeViewer && k.isVisible()) {
                        ((ModelEnablementTreeViewer)k).refresh(element);
                    }
                    ++n2;
                }
            }
        });
        this.treeViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }
        });
        this.treeViewer.setUseHashlookup(true);
    }

    public DataBindingContext setInput(List<ModelEnablementTreeEntry> entries) {
        if (this.treeViewer == null || entries == null) {
            return null;
        }
        DataBindingContext bindingContext = new DataBindingContext();
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ModelEnablementTreeEntry) {
                    return !((ModelEnablementTreeEntry)element).getChildren().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof ModelEnablementTreeEntry) {
                    return ((ModelEnablementTreeEntry)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof WritableList) {
                    return ((WritableList)inputElement).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ModelEnablementTreeEntry) {
                    return ((ModelEnablementTreeEntry)parentElement).getChildren().toArray();
                }
                return null;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ModelEnablementTreeEntry) {
                    return ((ModelEnablementTreeEntry)element).getName();
                }
                return null;
            }
        });
        WritableList writableList = new WritableList(entries, ModelEnablementTreeEntry.class);
        this.treeViewer.setInput((Object)writableList);
        return bindingContext;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.treeViewer.addCheckStateListener(listener);
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void refresh(Object element) {
        this.treeViewer.refresh(element);
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getParent().getLayout() instanceof GridLayout) {
            GridData data = (GridData)this.getLayoutData();
            data.exclude = !visible;
            this.getParent().layout();
        }
    }
}

