/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.gateway;

import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventBasedGatewayType;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateEventBasedGatewayFeature
extends AbstractUpdateFeature {
    public UpdateEventBasedGatewayFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object o = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return o != null && o instanceof EventBasedGateway;
    }

    public IReason updateNeeded(IUpdateContext context) {
        IPeService service = Graphiti.getPeService();
        boolean instantiate = Boolean.parseBoolean(service.getPropertyValue((PropertyContainer)context.getPictogramElement(), "instantiate"));
        EventBasedGatewayType gatewayType = EventBasedGatewayType.getByName((String)service.getPropertyValue((PropertyContainer)context.getPictogramElement(), "eventGatewayType"));
        EventBasedGateway gateway = (EventBasedGateway)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        boolean changed = instantiate != gateway.isInstantiate() || gatewayType != gateway.getEventGatewayType();
        return changed ? Reason.createTrueReason() : Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        IPeService service = Graphiti.getPeService();
        EventBasedGateway gateway = (EventBasedGateway)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        this.clearGateway(context.getPictogramElement());
        if (gateway.isInstantiate()) {
            if (gateway.getEventGatewayType() == EventBasedGatewayType.PARALLEL) {
                this.drawParallelMultipleEventBased((ContainerShape)context.getPictogramElement());
            } else {
                this.drawExclusiveEventBased((ContainerShape)context.getPictogramElement());
            }
        } else {
            this.drawEventBased((ContainerShape)context.getPictogramElement());
        }
        service.setPropertyValue((PropertyContainer)context.getPictogramElement(), "instantiate", Boolean.toString(gateway.isInstantiate()));
        service.setPropertyValue((PropertyContainer)context.getPictogramElement(), "eventGatewayType", gateway.getEventGatewayType().getName());
        return true;
    }

    private void clearGateway(PictogramElement element) {
        GraphicsUtil.clearGateway((PictogramElement)element);
    }

    private void drawEventBased(ContainerShape container) {
        if (FeatureSupport.isLabelShape((Shape)container)) {
            return;
        }
        Ellipse outer = GraphicsUtil.createGatewayOuterCircle((ContainerShape)container);
        GraphicsUtil.createGatewayInnerCircle((Ellipse)outer);
        Polygon pentagon = GraphicsUtil.createGatewayPentagon((ContainerShape)container);
        pentagon.setFilled(Boolean.valueOf(false));
    }

    private void drawExclusiveEventBased(ContainerShape container) {
        if (FeatureSupport.isLabelShape((Shape)container)) {
            return;
        }
        GraphicsUtil.createGatewayOuterCircle((ContainerShape)container);
        Polygon pentagon = GraphicsUtil.createGatewayPentagon((ContainerShape)container);
        pentagon.setFilled(Boolean.valueOf(false));
    }

    private void drawParallelMultipleEventBased(ContainerShape container) {
        if (FeatureSupport.isLabelShape((Shape)container)) {
            return;
        }
        GraphicsUtil.createGatewayOuterCircle((ContainerShape)container);
        GraphicsUtil.createEventGatewayParallelCross((ContainerShape)container);
    }
}

