/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutBoundaryEventFeature
extends AbstractLayoutFeature {
    public LayoutBoundaryEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        return true;
    }

    public boolean layout(ILayoutContext context) {
        boolean layout = false;
        PictogramElement element = context.getPictogramElement();
        GraphicsAlgorithm eventGa = element.getGraphicsAlgorithm();
        BoundaryEvent event = (BoundaryEvent)BusinessObjectUtil.getFirstElementOfType((PictogramElement)element, BoundaryEvent.class);
        PictogramElement activityContainer = BusinessObjectUtil.getFirstBaseElementFromDiagram((Diagram)this.getDiagram(), (BaseElement)event.getAttachedToRef());
        GraphicsAlgorithm activityGa = activityContainer.getGraphicsAlgorithm();
        BoundaryEventPositionHelper.PositionOnLine pos = BoundaryEventPositionHelper.getPositionOnLineProperty((PropertyContainer)element);
        switch (pos.getLineType()) {
            case X: {
                this.moveX(eventGa, activityGa, pos.getLocationType());
                if (eventGa.getY() < activityGa.getY() || eventGa.getY() + eventGa.getHeight() > activityGa.getY() + activityGa.getHeight()) {
                    this.moveY(eventGa, activityGa, pos.getLocationType());
                }
                layout = true;
                break;
            }
            case Y: {
                this.moveY(eventGa, activityGa, pos.getLocationType());
                if (eventGa.getX() < activityGa.getX() || eventGa.getX() + eventGa.getWidth() > activityGa.getX() + activityGa.getWidth()) {
                    this.moveX(eventGa, activityGa, pos.getLocationType());
                }
                layout = true;
                break;
            }
            case XY: {
                this.moveX(eventGa, activityGa, pos.getLocationType());
                this.moveY(eventGa, activityGa, pos.getLocationType());
                layout = true;
                break;
            }
            default: {
                layout = false;
            }
        }
        DIUtils.updateDIShape((PictogramElement)element);
        if (layout) {
            BoundaryEventPositionHelper.PositionOnLine newPos = BoundaryEventPositionHelper.getPositionOnLineUsingAbsoluteCoordinates((Shape)((Shape)element), (Shape)((Shape)activityContainer));
            BoundaryEventPositionHelper.assignPositionOnLineProperty((PropertyContainer)element, (BoundaryEventPositionHelper.PositionOnLine)newPos);
        }
        return layout;
    }

    private void moveX(GraphicsAlgorithm ga, GraphicsAlgorithm parentGa, BoundaryEventPositionHelper.PositionOnLine.LocationType locType) {
        IGaService gaService = Graphiti.getGaService();
        if (this.isLeft(locType)) {
            gaService.setLocation(ga, parentGa.getX() - ga.getWidth() / 2, ga.getY());
        } else if (this.isRight(locType)) {
            gaService.setLocation(ga, parentGa.getX() + parentGa.getWidth() - ga.getWidth() / 2, ga.getY());
        } else {
            gaService.setLocation(ga, parentGa.getX() + parentGa.getWidth() / 2 - ga.getWidth() / 2, ga.getY());
        }
    }

    private boolean isLeft(BoundaryEventPositionHelper.PositionOnLine.LocationType locType) {
        return locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.TOP_LEFT || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.LEFT || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.BOTTOM_LEFT;
    }

    private boolean isRight(BoundaryEventPositionHelper.PositionOnLine.LocationType locType) {
        return locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.TOP_RIGHT || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.RIGHT || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.BOTTOM_RIGHT;
    }

    private void moveY(GraphicsAlgorithm ga, GraphicsAlgorithm parentGa, BoundaryEventPositionHelper.PositionOnLine.LocationType locType) {
        IGaService gaService = Graphiti.getGaService();
        if (this.isTop(locType)) {
            gaService.setLocation(ga, ga.getX(), parentGa.getY() - ga.getHeight() / 2);
        } else if (this.isBottom(locType)) {
            gaService.setLocation(ga, ga.getX(), parentGa.getY() + parentGa.getHeight() - ga.getHeight() / 2);
        } else {
            gaService.setLocation(ga, ga.getX(), parentGa.getY() + parentGa.getHeight() / 2 - ga.getHeight() / 2);
        }
    }

    private boolean isTop(BoundaryEventPositionHelper.PositionOnLine.LocationType locType) {
        return locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.TOP_LEFT || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.TOP || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.TOP_RIGHT;
    }

    private boolean isBottom(BoundaryEventPositionHelper.PositionOnLine.LocationType locType) {
        return locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.BOTTOM_LEFT || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.BOTTOM || locType == BoundaryEventPositionHelper.PositionOnLine.LocationType.BOTTOM_RIGHT;
    }
}

