/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.data;

import java.util.ArrayList;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.data.MoveDataFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.bpmn2.modeler.ui.features.LayoutBaseElementTextFeature;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractDataFeatureContainer
extends BaseElementFeatureContainer {
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateLabelFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutBaseElementTextFeature(fp){

            @Override
            public int getMinimumWidth() {
                return 36;
            }
        };
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new MoveDataFeature(fp);
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeShapeFeature(fp){

            public boolean canResizeShape(IResizeShapeContext context) {
                return false;
            }
        };
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new AbstractDefaultDeleteFeature(fp){

            @Override
            public void delete(IDeleteContext context) {
                EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getPictogramElement());
                if (businessObject instanceof DataObject) {
                    ArrayList<PictogramElement> pictogramElements = new ArrayList<PictogramElement>();
                    Definitions definitions = ModelUtil.getDefinitions((EObject)businessObject);
                    TreeIterator iter = definitions.eAllContents();
                    while (iter.hasNext()) {
                        EObject obj = (EObject)iter.next();
                        if (!(obj instanceof DataObjectReference) || ((DataObjectReference)obj).getDataObjectRef() != businessObject) continue;
                        for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(this.getDiagram(), obj)) {
                            if (!(pe instanceof ContainerShape) || pictogramElements.contains(pe)) continue;
                            pictogramElements.add(pe);
                        }
                    }
                    for (PictogramElement pe : pictogramElements) {
                        DeleteContext dc = new DeleteContext(pe);
                        IDeleteFeature df = this.getFeatureProvider().getDeleteFeature((IDeleteContext)dc);
                        if (!df.canDelete((IDeleteContext)dc)) continue;
                        df.delete((IDeleteContext)dc);
                    }
                }
                super.delete(context);
            }
        };
    }
}

