/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class UpdateChoreographyMessageLinkFeature
extends AbstractUpdateFeature {
    public UpdateChoreographyMessageLinkFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return ChoreographyUtil.isChoreographyParticipantBand(context.getPictogramElement());
    }

    public IReason updateNeeded(IUpdateContext context) {
        if (!ChoreographyUtil.isChoreographyParticipantBand(context.getPictogramElement())) {
            return Reason.createFalseReason();
        }
        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), BPMNShape.class);
        boolean visible = new Boolean(Graphiti.getPeService().getPropertyValue((PropertyContainer)context.getPictogramElement(), "choreography.activity.band.message.visible"));
        return bpmnShape.isIsMessageVisible() != visible ? Reason.createTrueReason() : Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        if (!this.canUpdate(context)) {
            return false;
        }
        ChoreographyUtil.drawMessageLinks(this.getFeatureProvider(), (ContainerShape)context.getPictogramElement().eContainer());
        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), BPMNShape.class);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)context.getPictogramElement(), "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return true;
    }
}

