/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class UpdateChoreographyInitiatingParticipantFeature
extends AbstractUpdateFeature {
    private final IPeService peService = Graphiti.getPeService();

    public UpdateChoreographyInitiatingParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyActivity.class);
    }

    public IReason updateNeeded(IUpdateContext context) {
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyActivity.class);
        String id = this.peService.getPropertyValue((PropertyContainer)context.getPictogramElement(), "choreography.activity.initiating.participant.ref");
        Participant participant = choreography.getInitiatingParticipantRef();
        if ((id == null || id.equals("null")) && participant == null) {
            return Reason.createFalseReason();
        }
        if (participant != null && id != null && id.equals(participant.getId())) {
            return Reason.createFalseReason();
        }
        return Reason.createTrueReason();
    }

    public boolean update(IUpdateContext context) {
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, ChoreographyActivity.class);
        boolean hasInitiatingParticipant = choreography.getInitiatingParticipantRef() != null;
        for (ContainerShape band : ChoreographyUtil.getParticipantBandContainerShapes(container)) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            boolean isInitiating = hasInitiatingParticipant && participant.equals(choreography.getInitiatingParticipantRef());
            Color color = this.manageColor(isInitiating ? IColorConstant.WHITE : IColorConstant.LIGHT_GRAY);
            band.getGraphicsAlgorithm().setBackground(color);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            bpmnShape.setParticipantBandKind(this.getParticipantBandKind(isInitiating, bpmnShape.getParticipantBandKind()));
        }
        Participant initiatingParticipant = choreography.getInitiatingParticipantRef();
        String id = initiatingParticipant == null ? "null" : initiatingParticipant.getId();
        this.peService.setPropertyValue((PropertyContainer)context.getPictogramElement(), "choreography.activity.initiating.participant.ref", id);
        return true;
    }

    private ParticipantBandKind getParticipantBandKind(boolean initiating, ParticipantBandKind currentBandKind) {
        switch (currentBandKind) {
            case TOP_INITIATING: {
                return initiating ? currentBandKind : ParticipantBandKind.TOP_NON_INITIATING;
            }
            case MIDDLE_INITIATING: {
                return initiating ? currentBandKind : ParticipantBandKind.MIDDLE_NON_INITIATING;
            }
            case BOTTOM_INITIATING: {
                return initiating ? currentBandKind : ParticipantBandKind.BOTTOM_NON_INITIATING;
            }
            case TOP_NON_INITIATING: {
                return initiating ? ParticipantBandKind.TOP_INITIATING : currentBandKind;
            }
            case MIDDLE_NON_INITIATING: {
                return initiating ? ParticipantBandKind.MIDDLE_INITIATING : currentBandKind;
            }
            case BOTTOM_NON_INITIATING: {
                return initiating ? ParticipantBandKind.BOTTOM_INITIATING : currentBandKind;
            }
        }
        return currentBandKind;
    }
}

