/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyLoopType;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyProperties;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;

public class ChoreographyUtil
implements ChoreographyProperties {
    private static IGaService gaService = Graphiti.getGaService();
    private static IPeService peService = Graphiti.getPeService();

    public static List<ContainerShape> getParticipantBandContainerShapes(ContainerShape choreographyActivityContainerShape) {
        ArrayList<ContainerShape> containers = new ArrayList<ContainerShape>();
        Collection shapes = peService.getAllContainedShapes(choreographyActivityContainerShape);
        for (Shape s : shapes) {
            String property = peService.getPropertyValue((PropertyContainer)s, "choreography.activity.band");
            if (property == null || !new Boolean(property).booleanValue()) continue;
            containers.add((ContainerShape)s);
        }
        return containers;
    }

    public static List<BPMNShape> getParicipantBandBpmnShapes(ContainerShape choreographyActivityContainerShape) {
        ArrayList<BPMNShape> bpmnShapes = new ArrayList<BPMNShape>();
        List<ContainerShape> containers = ChoreographyUtil.getParticipantBandContainerShapes(choreographyActivityContainerShape);
        for (ContainerShape container : containers) {
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            bpmnShapes.add(bpmnShape);
        }
        return bpmnShapes;
    }

    public static boolean isChoreographyParticipantBand(PictogramElement element) {
        EObject container = element.eContainer();
        if (container instanceof PictogramElement) {
            PictogramElement containerElem = (PictogramElement)container;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(containerElem);
            if (bo instanceof ChoreographyActivity) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChoreographyMessageLink(PictogramElement pe) {
        EObject o = BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
        if (o instanceof MessageFlow && pe instanceof Connection) {
            Connection c = (Connection)pe;
            if (peService.getPropertyValue((PropertyContainer)c.getStart().getParent(), "choreography.messageLink") != null) {
                return true;
            }
            if (peService.getPropertyValue((PropertyContainer)c.getEnd().getParent(), "choreography.messageLink") != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChoreographyMessage(PictogramElement pe) {
        EObject o = BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
        return o instanceof Message && pe instanceof ContainerShape && peService.getPropertyValue((PropertyContainer)pe, "choreography.messageLink") != null;
    }

    public static boolean removeChoreographyMessageLink(PictogramElement pe) {
        if (ChoreographyUtil.isChoreographyMessageLink(pe)) {
            Connection connection = (Connection)pe;
            peService.deletePictogramElement((PictogramElement)connection.getEnd().getParent());
            peService.deletePictogramElement((PictogramElement)connection);
            return true;
        }
        return false;
    }

    public static Tuple<List<ContainerShape>, List<ContainerShape>> getTopAndBottomBands(List<ContainerShape> participantBands) {
        ArrayList<ContainerShape> top = new ArrayList<ContainerShape>();
        ArrayList<ContainerShape> bottom = new ArrayList<ContainerShape>();
        if (participantBands.size() == 1) {
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)((PictogramElement)participantBands.get(0)), BPMNShape.class);
            ParticipantBandKind bandKind = bpmnShape.getParticipantBandKind();
            if (bandKind == ParticipantBandKind.TOP_INITIATING || bandKind == ParticipantBandKind.TOP_NON_INITIATING) {
                top.add(participantBands.get(0));
            } else if (bandKind == ParticipantBandKind.BOTTOM_INITIATING || bandKind == ParticipantBandKind.BOTTOM_NON_INITIATING) {
                bottom.add(participantBands.get(0));
            } else {
                top.add(participantBands.get(0));
            }
        } else {
            Collections.sort(participantBands, ChoreographyUtil.getParticipantBandComparator());
            int n = participantBands.size();
            int divider = n / 2;
            top.addAll(participantBands.subList(0, divider));
            bottom.addAll(participantBands.subList(divider, n));
        }
        return new Tuple(top, bottom);
    }

    private static Comparator<ContainerShape> getParticipantBandComparator() {
        return new Comparator<ContainerShape>(){

            @Override
            public int compare(ContainerShape c1, ContainerShape c2) {
                BPMNShape bpmnShape1 = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c1, BPMNShape.class);
                Bounds bounds1 = bpmnShape1.getBounds();
                BPMNShape bpmnShape2 = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c2, BPMNShape.class);
                Bounds bounds2 = bpmnShape2.getBounds();
                return new Float(bounds1.getY()).compareTo(new Float(bounds2.getY()));
            }
        };
    }

    public static void resizePartipantBandContainerShapes(int w, int h, List<ContainerShape> top, List<ContainerShape> bottom, Diagram diagram) {
        Bounds bounds;
        BPMNShape bpmnShape;
        int y = 0;
        for (ContainerShape container : top) {
            bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            bounds = bpmnShape.getBounds();
            int hAcc = (int)bounds.getHeight();
            gaService.setLocationAndSize(container.getGraphicsAlgorithm(), 0, y, w, hAcc);
            y += hAcc;
            ChoreographyUtil.resizeParticipantBandChildren(container, w);
            DIUtils.updateDIShape((PictogramElement)container);
            AnchorUtil.relocateFixPointAnchors((Shape)container, (int)w, (int)((int)bounds.getHeight()));
        }
        Collections.reverse(bottom);
        y = h;
        for (ContainerShape container : bottom) {
            bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            bounds = bpmnShape.getBounds();
            y = (int)((float)y - bounds.getHeight());
            gaService.setLocationAndSize(container.getGraphicsAlgorithm(), 0, y, w, (int)bounds.getHeight());
            ChoreographyUtil.resizeParticipantBandChildren(container, w);
            DIUtils.updateDIShape((PictogramElement)container);
            AnchorUtil.relocateFixPointAnchors((Shape)container, (int)w, (int)((int)bounds.getHeight()));
        }
    }

    private static void resizeParticipantBandChildren(ContainerShape container, int w) {
        for (Shape s : container.getChildren()) {
            GraphicsAlgorithm ga = s.getGraphicsAlgorithm();
            if (ga instanceof Text) {
                gaService.setSize(ga, w, ga.getHeight());
                continue;
            }
            if (!(ga instanceof Rectangle)) continue;
            gaService.setLocation(ga, w / 2 - ga.getWidth() / 2, ga.getY());
        }
    }

    public static String getParticipantRefIds(ChoreographyActivity choreography) {
        if (choreography.getParticipantRefs() == null) {
            return new String();
        }
        Iterator iterator = choreography.getParticipantRefs().iterator();
        String delim = ":";
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Participant participant = (Participant)iterator.next();
            sb.append(participant.getId());
            if (!iterator.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String getMessageRefIds(ChoreographyTask choreography) {
        if (choreography.getMessageFlowRef() == null) {
            return new String();
        }
        Iterator iterator = choreography.getMessageFlowRef().iterator();
        String delim = ":";
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            MessageFlow message = (MessageFlow)iterator.next();
            sb.append(message.getId());
            if (!iterator.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static void updateParticipantReferences(ContainerShape choreographyContainer, List<ContainerShape> currentParticipantContainers, List<Participant> newParticipants, IFeatureProvider fp, boolean showNames) {
        Diagram diagram = peService.getDiagramForShape((Shape)choreographyContainer);
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyContainer, ChoreographyActivity.class);
        BPMNDiagram dia = (BPMNDiagram)BusinessObjectUtil.getFirstElementOfType((PictogramElement)diagram, BPMNDiagram.class);
        List diElements = dia.getPlane().getPlaneElement();
        int i = 0;
        while (i < currentParticipantContainers.size()) {
            ContainerShape container = currentParticipantContainers.get(i);
            for (Connection c : peService.getOutgoingConnections((AnchorContainer)container)) {
                EObject parent = c.getEnd().eContainer();
                if (!(parent instanceof PictogramElement)) continue;
                peService.deletePictogramElement((PictogramElement)parent);
            }
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            diElements.remove(bpmnShape);
            peService.deletePictogramElement((PictogramElement)container);
            ++i;
        }
        GraphicsAlgorithm ga = choreographyContainer.getGraphicsAlgorithm();
        IDimension size = gaService.calculateSize(ga);
        ArrayList<ContainerShape> newContainers = new ArrayList<ContainerShape>();
        int y = 0;
        boolean first = true;
        ArrayList<InteractionNode> sources = new ArrayList<InteractionNode>();
        if (choreography instanceof ChoreographyTask) {
            for (MessageFlow message : ((ChoreographyTask)choreography).getMessageFlowRef()) {
                sources.add(message.getSourceRef());
            }
        }
        Iterator<Participant> iterator = newParticipants.iterator();
        while (iterator.hasNext()) {
            Participant participant = iterator.next();
            ContainerShape bandShape = peService.createContainerShape(choreographyContainer, true);
            ParticipantBandKind bandKind = ChoreographyUtil.getNewParticipantBandKind(choreography, participant, first, !iterator.hasNext());
            boolean multiple = participant.getParticipantMultiplicity() != null && participant.getParticipantMultiplicity().getMaximum() > 1;
            int w = size.getWidth();
            int h = multiple ? 40 : 20;
            BPMNShape bpmnShape = DIUtils.createDIShape((Shape)bandShape, (BaseElement)participant, (int)0, (int)(y + h), (int)w, (int)h, (IFeatureProvider)fp, (Diagram)diagram);
            bpmnShape.setChoreographyActivityShape((BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyContainer, BPMNShape.class));
            bpmnShape.setIsMarkerVisible(multiple);
            bpmnShape.setParticipantBandKind(bandKind);
            bpmnShape.setIsMessageVisible(sources.contains(participant));
            ChoreographyUtil.createParticipantBandContainerShape(bandKind, choreographyContainer, bandShape, bpmnShape, showNames);
            if (multiple) {
                ChoreographyUtil.drawMultiplicityMarkers(bandShape);
            }
            newContainers.add(bandShape);
            y += h;
            first = false;
        }
        Tuple<List<ContainerShape>, List<ContainerShape>> topAndBottom = ChoreographyUtil.getTopAndBottomBands(newContainers);
        ChoreographyUtil.resizePartipantBandContainerShapes(size.getWidth(), size.getHeight(), (List)topAndBottom.getFirst(), (List)topAndBottom.getSecond(), diagram);
    }

    private static ContainerShape createTopShape(ContainerShape parent, ContainerShape bandShape, BPMNShape bpmnShape, boolean initiating, boolean showNames) {
        if (bandShape == null) {
            bandShape = peService.createContainerShape(parent, true);
        }
        Bounds bounds = bpmnShape.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)parent);
        RoundedRectangle band = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)bandShape, 10, 10);
        band.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        band.setBackground(initiating ? gaService.manageColor(diagram, IColorConstant.WHITE) : gaService.manageColor(diagram, IColorConstant.LIGHT_GRAY));
        gaService.setLocationAndSize((GraphicsAlgorithm)band, 0, 0, w, h);
        Participant p = (Participant)bpmnShape.getBpmnElement();
        if (showNames) {
            ChoreographyUtil.addBandLabel(bandShape, p.getName(), w, h);
        }
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)bandShape);
        AnchorUtil.addFixedPointAnchors((Shape)bandShape, (GraphicsAlgorithm)band);
        peService.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band", Boolean.toString(true));
        peService.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return bandShape;
    }

    private static ContainerShape createBottomShape(ContainerShape parent, ContainerShape bandShape, BPMNShape bpmnShape, boolean initiating, boolean showNames) {
        if (bandShape == null) {
            bandShape = peService.createContainerShape(parent, true);
        }
        Bounds bounds = bpmnShape.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        ILocation parentLoc = peService.getLocationRelativeToDiagram((Shape)parent);
        int y = (int)bounds.getY() - parentLoc.getY();
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)parent);
        RoundedRectangle band = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)bandShape, 10, 10);
        band.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        band.setBackground(initiating ? gaService.manageColor(diagram, IColorConstant.WHITE) : gaService.manageColor(diagram, IColorConstant.LIGHT_GRAY));
        gaService.setLocationAndSize((GraphicsAlgorithm)band, 0, y, w, h);
        Participant p = (Participant)bpmnShape.getBpmnElement();
        if (showNames) {
            ChoreographyUtil.addBandLabel(bandShape, p.getName(), w, h);
        }
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)bandShape);
        AnchorUtil.addFixedPointAnchors((Shape)bandShape, (GraphicsAlgorithm)band);
        peService.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band", Boolean.toString(true));
        peService.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return bandShape;
    }

    private static ContainerShape createMiddleShape(ContainerShape parent, ContainerShape bandShape, BPMNShape bpmnShape, boolean initiating, boolean showNames) {
        if (bandShape == null) {
            bandShape = peService.createContainerShape(parent, true);
        }
        Bounds bounds = bpmnShape.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        ILocation parentLoc = peService.getLocationRelativeToDiagram((Shape)parent);
        int y = (int)bounds.getY() - parentLoc.getY();
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)parent);
        Rectangle band = gaService.createRectangle((GraphicsAlgorithmContainer)bandShape);
        band.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        band.setBackground(initiating ? gaService.manageColor(diagram, IColorConstant.WHITE) : gaService.manageColor(diagram, IColorConstant.LIGHT_GRAY));
        gaService.setLocationAndSize((GraphicsAlgorithm)band, 0, y, w, h);
        Participant p = (Participant)bpmnShape.getBpmnElement();
        if (showNames) {
            ChoreographyUtil.addBandLabel(bandShape, p.getName(), w, h);
        }
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)bandShape);
        AnchorUtil.addFixedPointAnchors((Shape)bandShape, (GraphicsAlgorithm)band);
        peService.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band", Boolean.toString(true));
        peService.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return bandShape;
    }

    private static void addBandLabel(ContainerShape container, String name, int w, int h) {
        Diagram diagram = peService.getDiagramForShape((Shape)container);
        Shape labelShape = peService.createShape(container, false);
        Text label = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)labelShape);
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)container);
        label.setValue(name);
        gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, 0, w, h);
        StyleUtil.applyStyle((GraphicsAlgorithm)label, (BaseElement)be);
        label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
    }

    private static ParticipantBandKind getNewParticipantBandKind(ChoreographyActivity choreography, Participant participant, boolean first, boolean last) {
        boolean initiating;
        boolean bl = initiating = choreography.getInitiatingParticipantRef() != null && choreography.getInitiatingParticipantRef().equals(participant);
        if (first) {
            return initiating ? ParticipantBandKind.TOP_INITIATING : ParticipantBandKind.TOP_NON_INITIATING;
        }
        if (last) {
            return initiating ? ParticipantBandKind.BOTTOM_INITIATING : ParticipantBandKind.BOTTOM_NON_INITIATING;
        }
        return initiating ? ParticipantBandKind.MIDDLE_INITIATING : ParticipantBandKind.MIDDLE_NON_INITIATING;
    }

    private static ContainerShape drawMessageLink(String name, AnchorUtil.BoundaryAnchor boundaryAnchor, int x, int y, boolean filled) {
        Diagram diagram = peService.getDiagramForAnchor((Anchor)boundaryAnchor.anchor);
        FreeFormConnection connection = peService.createFreeFormConnection(diagram);
        Polyline connectionLine = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
        connectionLine.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        connectionLine.setLineStyle(LineStyle.DOT);
        connectionLine.setLineWidth(Integer.valueOf(2));
        ContainerShape envelope = peService.createContainerShape((ContainerShape)diagram, true);
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)envelope);
        gaService.setLocation((GraphicsAlgorithm)invisibleRectangle, x, y);
        gaService.setSize((GraphicsAlgorithm)invisibleRectangle, 80, 18);
        Shape envelopeShape = peService.createShape(envelope, false);
        GraphicsUtil.Envelope envelopeGa = GraphicsUtil.createEnvelope((GraphicsAlgorithmContainer)envelopeShape, (int)0, (int)0, (int)30, (int)18);
        IColorConstant color = filled ? IColorConstant.LIGHT_GRAY : IColorConstant.WHITE;
        envelopeGa.rect.setFilled(Boolean.valueOf(true));
        envelopeGa.rect.setBackground(gaService.manageColor(diagram, color));
        envelopeGa.rect.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        envelopeGa.line.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        AnchorUtil.addFixedPointAnchors((Shape)envelope, (GraphicsAlgorithm)envelopeGa.rect);
        Shape textShape = peService.createShape(envelope, false);
        Text text = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)textShape);
        IDimension size = GraphitiUi.getUiLayoutService().calculateTextSize(name, text.getFont());
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 33, 3, size.getWidth(), size.getHeight());
        text.setValue(name);
        gaService.setSize((GraphicsAlgorithm)invisibleRectangle, 30 + size.getWidth() + 3, 18);
        AnchorUtil.AnchorLocation envelopeAnchorLoc = null;
        envelopeAnchorLoc = boundaryAnchor.locationType == AnchorUtil.AnchorLocation.TOP ? AnchorUtil.AnchorLocation.BOTTOM : AnchorUtil.AnchorLocation.TOP;
        connection.setStart((Anchor)boundaryAnchor.anchor);
        connection.setEnd((Anchor)((AnchorUtil.BoundaryAnchor)AnchorUtil.getBoundaryAnchors((AnchorContainer)envelope).get((Object)envelopeAnchorLoc)).anchor);
        peService.setPropertyValue((PropertyContainer)envelope, "choreography.messageLink", Boolean.toString(true));
        return envelope;
    }

    public static void drawMultiplicityMarkers(ContainerShape container) {
        int[][] coorinates;
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)container);
        Shape multiplicityShape = peService.createShape(container, false);
        Rectangle rect = gaService.createInvisibleRectangle((PictogramElement)multiplicityShape);
        IDimension size = gaService.calculateSize(container.getGraphicsAlgorithm());
        int w = 10;
        int h = 10;
        int x = size.getWidth() / 2 - w / 2;
        int y = size.getHeight() - h - 1;
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, x, y, w, h);
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[4];
        nArray[3] = h;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 4;
        nArray2[2] = 4;
        nArray2[3] = h;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 8;
        nArray3[2] = 8;
        nArray3[3] = h;
        nArrayArray[2] = nArray3;
        int[][] nArrayArray2 = coorinates = nArrayArray;
        int n = coorinates.length;
        int n2 = 0;
        while (n2 < n) {
            int[] xy = nArrayArray2[n2];
            Polyline line = gaService.createPolyline((GraphicsAlgorithmContainer)rect, xy);
            line.setLineWidth(Integer.valueOf(2));
            line.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
            ++n2;
        }
    }

    public static ContainerShape createParticipantBandContainerShape(ParticipantBandKind bandKind, ContainerShape container, ContainerShape bandContainer, BPMNShape bpmnShape, boolean showNames) {
        switch (bandKind) {
            case TOP_INITIATING: {
                return ChoreographyUtil.createTopShape(container, bandContainer, bpmnShape, true, showNames);
            }
            case TOP_NON_INITIATING: {
                return ChoreographyUtil.createTopShape(container, bandContainer, bpmnShape, false, showNames);
            }
            case MIDDLE_INITIATING: {
                return ChoreographyUtil.createMiddleShape(container, bandContainer, bpmnShape, true, showNames);
            }
            case MIDDLE_NON_INITIATING: {
                return ChoreographyUtil.createMiddleShape(container, bandContainer, bpmnShape, false, showNames);
            }
            case BOTTOM_INITIATING: {
                return ChoreographyUtil.createBottomShape(container, bandContainer, bpmnShape, true, showNames);
            }
            case BOTTOM_NON_INITIATING: {
                return ChoreographyUtil.createBottomShape(container, bandContainer, bpmnShape, false, showNames);
            }
        }
        return bandContainer;
    }

    public static ContainerShape createParticipantBandContainerShape(ParticipantBandKind bandKind, ContainerShape container, BPMNShape bpmnShape, boolean showNames) {
        return ChoreographyUtil.createParticipantBandContainerShape(bandKind, container, null, bpmnShape, showNames);
    }

    public static void drawMessageLinks(IFeatureProvider fp, ContainerShape choreographyContainer) {
        int y;
        ArrayList<MessageFlow> messageFlows = new ArrayList<MessageFlow>();
        ChoreographyTask choreography = (ChoreographyTask)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyContainer, ChoreographyTask.class);
        if (choreography != null) {
            messageFlows.addAll(choreography.getMessageFlowRef());
        }
        List<ContainerShape> bandContainers = ChoreographyUtil.getParticipantBandContainerShapes(choreographyContainer);
        Tuple<List<ContainerShape>, List<ContainerShape>> topAndBottom = ChoreographyUtil.getTopAndBottomBands(bandContainers);
        ArrayList<ContainerShape> shapesWithVisibleMessages = new ArrayList<ContainerShape>();
        Map boundaryAnchors = AnchorUtil.getBoundaryAnchors((AnchorContainer)choreographyContainer);
        AnchorUtil.BoundaryAnchor topBoundaryAnchor = (AnchorUtil.BoundaryAnchor)boundaryAnchors.get(AnchorUtil.AnchorLocation.TOP);
        AnchorUtil.BoundaryAnchor bottomBoundaryAnchor = (AnchorUtil.BoundaryAnchor)boundaryAnchors.get(AnchorUtil.AnchorLocation.BOTTOM);
        int topConnectionIndex = 0;
        int bottomConnectionIndex = 0;
        boolean hasTopMessage = false;
        EList topConnections = topBoundaryAnchor.anchor.getOutgoingConnections();
        int i = 0;
        while (i < topConnections.size()) {
            String property;
            Connection connection = (Connection)topConnections.get(i);
            EObject container = connection.getEnd().eContainer();
            if (container instanceof PropertyContainer && Boolean.parseBoolean(property = peService.getPropertyValue((PropertyContainer)container, "choreography.messageLink"))) {
                topConnectionIndex = i;
                hasTopMessage = true;
                break;
            }
            ++i;
        }
        boolean hasBottomMessage = false;
        EList bottomConnections = bottomBoundaryAnchor.anchor.getOutgoingConnections();
        int i2 = 0;
        while (i2 < bottomConnections.size()) {
            String property;
            Connection connection = (Connection)bottomConnections.get(i2);
            EObject container = connection.getEnd().eContainer();
            if (container instanceof PropertyContainer && Boolean.parseBoolean(property = peService.getPropertyValue((PropertyContainer)container, "choreography.messageLink"))) {
                bottomConnectionIndex = i2;
                hasBottomMessage = true;
                break;
            }
            ++i2;
        }
        for (ContainerShape bandContainer : bandContainers) {
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)bandContainer, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible()) continue;
            shapesWithVisibleMessages.add(bandContainer);
        }
        boolean shouldDrawTopMessage = !Collections.disjoint((Collection)topAndBottom.getFirst(), shapesWithVisibleMessages);
        boolean shouldDrawBottomMessage = !Collections.disjoint((Collection)topAndBottom.getSecond(), shapesWithVisibleMessages);
        String topMessageName = null;
        String bottomMessageName = null;
        Message topMessage = null;
        Message bottomMessage = null;
        if (shouldDrawTopMessage) {
            topMessage = ChoreographyUtil.getMessage(messageFlows, (List)topAndBottom.getFirst(), false);
            topMessageName = ChoreographyUtil.getMessageName(messageFlows, (List)topAndBottom.getFirst());
        }
        if (topMessageName == null) {
            topMessageName = new String();
        }
        if (shouldDrawBottomMessage) {
            bottomMessage = ChoreographyUtil.getMessage(messageFlows, (List)topAndBottom.getSecond(), false);
            bottomMessageName = ChoreographyUtil.getMessageName(messageFlows, (List)topAndBottom.getSecond());
        }
        if (bottomMessageName == null) {
            bottomMessageName = new String();
        }
        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyContainer, BPMNShape.class);
        Bounds bounds = bpmnShape.getBounds();
        int x = (int)(bounds.getX() + bounds.getWidth() / 2.0f - 15.0f);
        MessageFlow flow = ChoreographyUtil.getMessageFlow(messageFlows, (List)topAndBottom.getFirst());
        ContainerShape envelope = null;
        if (!hasTopMessage && shouldDrawTopMessage && flow != null) {
            y = (int)(bounds.getY() - 30.0f - 18.0f);
            envelope = ChoreographyUtil.drawMessageLink(topMessageName, topBoundaryAnchor, x, y, ChoreographyUtil.isFilled((List)topAndBottom.getFirst()));
            if (topMessage != null) {
                fp.link((PictogramElement)envelope, (Object)topMessage);
            }
            peService.setPropertyValue((PropertyContainer)envelope, "choreography.messageName", topMessageName);
        } else if (hasTopMessage && !shouldDrawTopMessage) {
            envelope = (ContainerShape)((Connection)topConnections.get(topConnectionIndex)).getEnd().eContainer();
            peService.deletePictogramElement((PictogramElement)topConnections.get(topConnectionIndex));
            peService.deletePictogramElement((PictogramElement)envelope);
            envelope = null;
        } else if (hasTopMessage && shouldDrawTopMessage && flow != null) {
            envelope = (ContainerShape)((Connection)topConnections.get(topConnectionIndex)).getEnd().eContainer();
            ChoreographyUtil.setMessageLabel(topMessageName, (PictogramElement)envelope);
        }
        if (envelope != null) {
            ChoreographyUtil.linkMessageFlow(fp, flow, envelope);
        }
        envelope = null;
        flow = ChoreographyUtil.getMessageFlow(messageFlows, (List)topAndBottom.getSecond());
        if (!hasBottomMessage && shouldDrawBottomMessage && flow != null) {
            y = (int)(bounds.getY() + bounds.getHeight() + 30.0f);
            envelope = ChoreographyUtil.drawMessageLink(bottomMessageName, bottomBoundaryAnchor, x, y, ChoreographyUtil.isFilled((List)topAndBottom.getSecond()));
            if (bottomMessage != null) {
                fp.link((PictogramElement)envelope, (Object)bottomMessage);
            }
            peService.setPropertyValue((PropertyContainer)envelope, "choreography.messageName", bottomMessageName);
        } else if (hasBottomMessage && !shouldDrawBottomMessage) {
            envelope = (ContainerShape)((Connection)bottomConnections.get(bottomConnectionIndex)).getEnd().eContainer();
            peService.deletePictogramElement((PictogramElement)bottomConnections.get(bottomConnectionIndex));
            peService.deletePictogramElement((PictogramElement)envelope);
            envelope = null;
        } else if (hasBottomMessage && shouldDrawBottomMessage && flow != null) {
            envelope = (ContainerShape)((Connection)bottomConnections.get(bottomConnectionIndex)).getEnd().eContainer();
            ChoreographyUtil.setMessageLabel(bottomMessageName, (PictogramElement)envelope);
        }
        if (envelope != null) {
            ChoreographyUtil.linkMessageFlow(fp, flow, envelope);
        }
    }

    private static void linkMessageFlow(IFeatureProvider fp, MessageFlow flow, ContainerShape envelope) {
        for (Anchor a : envelope.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                fp.link((PictogramElement)c, (Object)flow);
            }
            for (Connection c : a.getOutgoingConnections()) {
                fp.link((PictogramElement)c, (Object)flow);
            }
        }
    }

    private static boolean isFilled(List<ContainerShape> bands) {
        boolean filled = true;
        for (ContainerShape band : bands) {
            ParticipantBandKind bandKind;
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible() || (bandKind = bpmnShape.getParticipantBandKind()) != ParticipantBandKind.TOP_INITIATING && bandKind != ParticipantBandKind.BOTTOM_INITIATING && bandKind != ParticipantBandKind.MIDDLE_INITIATING) continue;
            filled = false;
            break;
        }
        return filled;
    }

    private static void setMessageLabel(String label, PictogramElement message) {
        ContainerShape containerShape = (ContainerShape)message;
        for (Shape shape : peService.getAllContainedShapes(containerShape)) {
            if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
            Text text = (Text)shape.getGraphicsAlgorithm();
            text.setValue(label);
            IDimension size = GraphitiUi.getUiLayoutService().calculateTextSize(label, text.getFont());
            gaService.setSize(containerShape.getGraphicsAlgorithm(), 30 + size.getWidth() + 3, 18);
            gaService.setSize((GraphicsAlgorithm)text, size.getWidth(), size.getHeight());
            peService.setPropertyValue((PropertyContainer)containerShape, "choreography.messageName", label);
            break;
        }
    }

    private static String getMessageName(List<MessageFlow> messageFlows, List<ContainerShape> bands) {
        for (ContainerShape band : bands) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible()) continue;
            for (MessageFlow flow : messageFlows) {
                if (!flow.getSourceRef().equals(participant)) continue;
                return ChoreographyUtil.getMessageFlowName(flow);
            }
        }
        return null;
    }

    private static MessageFlow getMessageFlow(List<MessageFlow> messageFlows, List<ContainerShape> bands) {
        for (ContainerShape band : bands) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible()) continue;
            for (MessageFlow flow : messageFlows) {
                if (!flow.getSourceRef().equals(participant)) continue;
                return flow;
            }
        }
        return null;
    }

    private static Message getMessage(List<MessageFlow> messageFlows, List<ContainerShape> bands, boolean create) {
        MessageFlow flow = ChoreographyUtil.getMessageFlow(messageFlows, bands);
        if (flow != null) {
            if (flow.getMessageRef() == null && create) {
                Message msg = (Message)Bpmn2ModelerFactory.create(Message.class);
                msg.setName(Messages.ChoreographyUtil_Undefined_Message);
                ModelUtil.getDefinitions((EObject)flow).getRootElements().add(msg);
                flow.setMessageRef(msg);
                ModelUtil.setID((EObject)msg);
            }
            return flow.getMessageRef();
        }
        return null;
    }

    public static String getMessageFlowName(MessageFlow flow) {
        String itemDefinitionName;
        if (flow.getMessageRef() == null) {
            return flow.getName();
        }
        if (flow.getMessageRef().getItemRef() == null || flow.getMessageRef().getItemRef().getStructureRef() == null) {
            return flow.getMessageRef().getName();
        }
        String messageName = flow.getMessageRef().getName();
        String text = itemDefinitionName = ModelUtil.getDisplayName((Object)flow.getMessageRef().getItemRef());
        if (messageName != null && !messageName.isEmpty()) {
            text = String.valueOf(text) + "/" + messageName;
        }
        text = messageName;
        return text;
    }

    public static String getMessageName(Message mesg) {
        if (mesg.getItemRef() == null || mesg.getItemRef().getStructureRef() == null) {
            if (mesg.getName() == null) {
                return mesg.getId();
            }
            return mesg.getName();
        }
        String type = "(" + ModelUtil.getDisplayName((Object)mesg.getItemRef()) + ")";
        if (mesg.getName() == null) {
            return type;
        }
        return String.valueOf(mesg.getName()) + type;
    }

    public static void updateChoreographyMessageLinks(IPictogramElementContext context) {
        ContainerShape choreographyTaskShape = (ContainerShape)context.getPictogramElement();
        ChoreographyUtil.moveChoreographyMessageLinks(choreographyTaskShape);
    }

    public static void moveChoreographyMessageLinks(ContainerShape choreographyTaskShape) {
        int y;
        String property;
        EObject container;
        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyTaskShape, BPMNShape.class);
        Bounds bounds = bpmnShape.getBounds();
        int x = (int)(bounds.getX() + bounds.getWidth() / 2.0f - 15.0f);
        Map boundaryAnchors = AnchorUtil.getBoundaryAnchors((AnchorContainer)choreographyTaskShape);
        AnchorUtil.BoundaryAnchor topBoundaryAnchor = (AnchorUtil.BoundaryAnchor)boundaryAnchors.get(AnchorUtil.AnchorLocation.TOP);
        AnchorUtil.BoundaryAnchor bottomBoundaryAnchor = (AnchorUtil.BoundaryAnchor)boundaryAnchors.get(AnchorUtil.AnchorLocation.BOTTOM);
        for (Connection connection : topBoundaryAnchor.anchor.getOutgoingConnections()) {
            container = connection.getEnd().eContainer();
            if (!(container instanceof PropertyContainer) || (property = peService.getPropertyValue((PropertyContainer)container, "choreography.messageLink")) == null || !new Boolean(property).booleanValue()) continue;
            y = (int)(bounds.getY() - 30.0f - 18.0f);
            gaService.setLocation(((ContainerShape)container).getGraphicsAlgorithm(), x, y);
            break;
        }
        for (Connection connection : bottomBoundaryAnchor.anchor.getOutgoingConnections()) {
            container = connection.getEnd().eContainer();
            if (!(container instanceof PropertyContainer) || (property = peService.getPropertyValue((PropertyContainer)container, "choreography.messageLink")) == null || !new Boolean(property).booleanValue()) continue;
            y = (int)(bounds.getY() + bounds.getHeight() + 30.0f);
            gaService.setLocation(((ContainerShape)container).getGraphicsAlgorithm(), x, y);
            break;
        }
    }

    public static void drawChoreographyLoopType(ContainerShape markerShape, ChoreographyLoopType type) {
        Iterator iterator;
        Collection shapes = peService.getAllContainedShapes(markerShape);
        Shape drawingShape = null;
        if (shapes.size() == 1 && (iterator = shapes.iterator()).hasNext()) {
            Shape shape;
            drawingShape = shape = (Shape)iterator.next();
        }
        if (drawingShape != null) {
            peService.deletePictogramElement(drawingShape);
        }
        drawingShape = peService.createShape(markerShape, false);
        Rectangle rectangle = gaService.createInvisibleRectangle((PictogramElement)drawingShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)rectangle, 0, 0, 20, 20);
        if (type == null || type == ChoreographyLoopType.NONE) {
            return;
        }
        switch (type) {
            case STANDARD: {
                break;
            }
            case MULTI_INSTANCE_PARALLEL: {
                break;
            }
        }
    }
}

