/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AddChoreographyActivityFeature<T extends ChoreographyActivity>
extends AbstractBpmn2AddElementFeature<T> {
    protected final IGaService gaService = Graphiti.getGaService();
    protected final IPeService peService = Graphiti.getPeService();

    public AddChoreographyActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getTargetContainer().equals(this.getDiagram());
    }

    public PictogramElement add(IAddContext context) {
        boolean isImport;
        ChoreographyActivity businessObject = (ChoreographyActivity)this.getBusinessObject(context);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        ContainerShape containerShape = this.peService.createContainerShape(context.getTargetContainer(), true);
        RoundedRectangle containerRect = this.gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 10, 10);
        this.gaService.setLocationAndSize((GraphicsAlgorithm)containerRect, context.getX(), context.getY(), width, height);
        StyleUtil.applyStyle((GraphicsAlgorithm)containerRect, (BaseElement)businessObject);
        boolean bl = isImport = context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null;
        if (isImport) {
            this.addedFromImport(businessObject, containerShape, context);
        }
        Shape nameShape = this.peService.createShape(containerShape, false);
        MultiText text = this.gaService.createDefaultMultiText(this.getDiagram(), (GraphicsAlgorithmContainer)nameShape);
        text.setValue(businessObject.getName());
        StyleUtil.applyStyle((GraphicsAlgorithm)text, (BaseElement)businessObject);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        this.setTextLocation(containerShape, (AbstractText)text, width, height);
        this.peService.setPropertyValue((PropertyContainer)nameShape, "choreography.name", Boolean.toString(true));
        GraphicsUtil.hideActivityMarker((ContainerShape)containerShape, (String)"activity.marker.expand");
        if (businessObject instanceof ChoreographyTask) {
            this.peService.setPropertyValue((PropertyContainer)containerShape, "choreography.message.ref.ids", ChoreographyUtil.getMessageRefIds((ChoreographyTask)businessObject));
        }
        this.peService.createChopboxAnchor((AnchorContainer)containerShape);
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        this.decorateShape(context, containerShape, (BaseElement)businessObject);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)containerRect);
        ChoreographyUtil.drawMessageLinks(this.getFeatureProvider(), containerShape);
        return containerShape;
    }

    protected void addedFromImport(T choreographyActivity, ContainerShape containerShape, IAddContext context) {
        List participants = choreographyActivity.getParticipantRefs();
        List allShapes = ModelUtil.getAllObjectsOfType((Resource)choreographyActivity.eResource(), BPMNShape.class);
        ArrayList<BPMNShape> participantBandShapes = new ArrayList<BPMNShape>();
        BPMNShape choreoBpmnShape = null;
        for (BPMNShape bpmnShape : allShapes) {
            if (!choreographyActivity.equals(bpmnShape.getBpmnElement())) continue;
            choreoBpmnShape = bpmnShape;
            break;
        }
        for (BPMNShape bpmnShape : allShapes) {
            if (!participants.contains(bpmnShape.getBpmnElement()) || !choreoBpmnShape.equals(bpmnShape.getChoreographyActivityShape())) continue;
            participantBandShapes.add(bpmnShape);
        }
        for (BPMNShape bpmnShape : participantBandShapes) {
            ParticipantBandKind bandKind = bpmnShape.getParticipantBandKind();
            ContainerShape createdShape = ChoreographyUtil.createParticipantBandContainerShape(bandKind, containerShape, bpmnShape, this.isShowNames());
            this.createDIShape((Shape)createdShape, bpmnShape.getBpmnElement(), bpmnShape, false);
            Participant p = (Participant)bpmnShape.getBpmnElement();
            if (p.getParticipantMultiplicity() == null || p.getParticipantMultiplicity().getMaximum() <= 1) continue;
            ChoreographyUtil.drawMultiplicityMarkers(createdShape);
        }
        this.peService.setPropertyValue((PropertyContainer)containerShape, "choreography.activity.participant.ref.ids", ChoreographyUtil.getParticipantRefIds(choreographyActivity));
        Participant initiatingParticipant = choreographyActivity.getInitiatingParticipantRef();
        String id = initiatingParticipant == null ? "null" : initiatingParticipant.getId();
        this.peService.setPropertyValue((PropertyContainer)containerShape, "choreography.activity.initiating.participant.ref", id);
    }

    protected void setTextLocation(ContainerShape choreographyContainer, AbstractText text, int w, int h) {
        this.gaService.setLocationAndSize((GraphicsAlgorithm)text, 5, 5, w - 5, h);
    }

    protected boolean isShowNames() {
        return true;
    }

    public int getHeight() {
        return 150;
    }

    public int getWidth() {
        return 150;
    }
}

