/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractExpandableActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.osgi.util.NLS;

public class UpdateExpandableActivityFeature
extends AbstractUpdateFeature {
    public UpdateExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return AbstractExpandableActivityFeatureContainer.isExpandableElement(bo);
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Property triggerProperty = Graphiti.getPeService().getProperty((PropertyContainer)pe, "triggered-by-event-key");
        Property expandedProperty = Graphiti.getPeService().getProperty((PropertyContainer)pe, "is-expanded-key");
        SubProcess subprocess = (SubProcess)this.getBusinessObjectForPictogramElement(pe);
        try {
            BPMNShape bpmnShape = DIUtils.findBPMNShape((BaseElement)subprocess);
            if (expandedProperty != null && Boolean.parseBoolean(expandedProperty.getValue()) != bpmnShape.isIsExpanded()) {
                return Reason.createTrueReason((String)Messages.UpdateExpandableActivityFeature_Expand_Changed);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(NLS.bind((String)Messages.UpdateExpandableActivityFeature_No_DI_Element, (Object)subprocess));
        }
        if (triggerProperty != null && Boolean.parseBoolean(triggerProperty.getValue()) != subprocess.isTriggeredByEvent()) {
            return Reason.createTrueReason((String)Messages.UpdateExpandableActivityFeature_Trigger_Changed);
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        SubProcess subprocess = (SubProcess)this.getBusinessObjectForPictogramElement(pe);
        ContainerShape container = (ContainerShape)pe;
        boolean isExpanded = false;
        BPMNShape bpmnShape = DIUtils.findBPMNShape((BaseElement)subprocess);
        isExpanded = bpmnShape.isIsExpanded();
        Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "triggered-by-event-key", Boolean.toString(subprocess.isTriggeredByEvent()));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "is-expanded-key", Boolean.toString(isExpanded));
        GraphicsAlgorithm rectangle = ((PictogramElement)Graphiti.getPeService().getAllContainedPictogramElements(pe).iterator().next()).getGraphicsAlgorithm();
        LineStyle lineStyle = subprocess.isTriggeredByEvent() ? LineStyle.DOT : LineStyle.SOLID;
        rectangle.setLineStyle(lineStyle);
        if (!isExpanded) {
            FeatureSupport.setContainerChildrenVisible((ContainerShape)container, (boolean)false);
            GraphicsUtil.showActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
        } else {
            FeatureSupport.setContainerChildrenVisible((ContainerShape)container, (boolean)true);
            GraphicsUtil.hideActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
        }
        return true;
    }
}

