/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.activity.LayoutActivityFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class LayoutExpandableActivityFeature
extends LayoutActivityFeature {
    public LayoutExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected boolean layoutHook(Shape shape, GraphicsAlgorithm ga, Object bo, int newWidth, int newHeight) {
        if (bo != null && ga instanceof AbstractText) {
            EObject container = shape.eContainer();
            while (container != null) {
                EObject object;
                if (container instanceof ContainerShape && (object = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape)) instanceof FlowElementsContainer) {
                    GraphicsAlgorithm parentGa = ((ContainerShape)container).getGraphicsAlgorithm();
                    newWidth = parentGa.getWidth();
                    newHeight = parentGa.getHeight();
                    Graphiti.getGaService().setLocationAndSize(ga, 5, 10, newWidth - 10, newHeight);
                    return true;
                }
                container = container.eContainer();
            }
        }
        return false;
    }

    public boolean layout(ILayoutContext context) {
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        Activity activity = (Activity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Activity.class);
        try {
            BPMNShape shape = DIUtils.findBPMNShape((BaseElement)activity);
            if (shape.isIsExpanded()) {
                boolean needResize = false;
                GraphicsAlgorithm parentGa = containerShape.getGraphicsAlgorithm();
                for (PictogramElement pe : FeatureSupport.getContainerChildren((ContainerShape)containerShape)) {
                    GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
                    if (ga == null) continue;
                    if (ga.getX() < 0 || ga.getY() < 0) {
                        needResize = true;
                        break;
                    }
                    if (ga.getX() + ga.getWidth() > parentGa.getWidth()) {
                        needResize = true;
                        break;
                    }
                    if (ga.getY() + ga.getHeight() <= parentGa.getHeight()) continue;
                    needResize = true;
                    break;
                }
                if (needResize) {
                    ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                    resizeContext.setX(parentGa.getX());
                    resizeContext.setY(parentGa.getY());
                    resizeContext.setWidth(parentGa.getWidth());
                    resizeContext.setHeight(parentGa.getHeight());
                    IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                    resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                }
                FeatureSupport.setContainerChildrenVisible((ContainerShape)containerShape, (boolean)true);
            } else {
                FeatureSupport.setContainerChildrenVisible((ContainerShape)containerShape, (boolean)false);
            }
        }
        catch (Exception exception) {}
        return super.layout(context);
    }
}

