/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.RootElementRefFeatureDescriptor;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MessageFlowPropertiesAdapter
extends ExtendedPropertiesAdapter<MessageFlow> {
    public MessageFlowPropertiesAdapter(AdapterFactory adapterFactory, MessageFlow object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getMessageFlow_MessageRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new RootElementRefFeatureDescriptor<MessageFlow>(adapterFactory, object, (EStructuralFeature)ref){

            public void setValue(Object context, Object value) {
                if (value instanceof Message || value == null) {
                    final MessageFlow object = (MessageFlow)this.adopt(context);
                    final Message message = (Message)value;
                    TransactionalEditingDomain editingDomain = this.getEditingDomain(object);
                    if (editingDomain == null) {
                        MessageFlowPropertiesAdapter.this.setMessageRef(object, message);
                    } else {
                        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                            protected void doExecute() {
                                MessageFlowPropertiesAdapter.this.setMessageRef(object, message);
                            }
                        });
                    }
                }
            }
        });
        this.setObjectDescriptor((ObjectDescriptor)new ObjectDescriptor<MessageFlow>(adapterFactory, object){

            public String getDisplayName(Object context) {
                MessageFlow flow = (MessageFlow)this.adopt(context);
                String text = "";
                if (flow.getName() != null) {
                    text = flow.getName();
                } else {
                    if (flow.getMessageRef() != null) {
                        text = String.valueOf(text) + ChoreographyUtil.getMessageFlowName(flow);
                    }
                    if (flow.getSourceRef() != null) {
                        text = String.valueOf(text) + "(" + ModelUtil.getDisplayName((Object)flow.getSourceRef()) + "->";
                        if (flow.getTargetRef() != null) {
                            text = String.valueOf(text) + ModelUtil.getDisplayName((Object)flow.getTargetRef());
                        }
                        text = String.valueOf(text) + ")";
                    }
                }
                return text;
            }
        });
    }

    private void setMessageRef(MessageFlow messageFlow, Message message) {
        ResourceSet resourceSet = messageFlow.eResource().getResourceSet();
        messageFlow.setMessageRef(message);
        List connections = DIUtils.getConnections((ResourceSet)resourceSet, (BaseElement)messageFlow);
        for (Connection connection : connections) {
            BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection.getEnd().getParent());
            if (o instanceof ReceiveTask) {
                ((ReceiveTask)o).setMessageRef(message);
            }
            if (!((o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection.getStart().getParent())) instanceof SendTask)) continue;
            ((SendTask)o).setMessageRef(message);
        }
    }
}

