/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FlowElementPropertiesAdapter<T extends FlowElement>
extends ExtendedPropertiesAdapter<T> {
    public FlowElementPropertiesAdapter(AdapterFactory adapterFactory, T object) {
        super(adapterFactory, object);
        EAttribute f = Bpmn2Package.eINSTANCE.getFlowElement_Name();
        final FeatureDescriptor fd = new FeatureDescriptor<T>(adapterFactory, (FlowElement)object, (EStructuralFeature)f){

            public void setDisplayName(String text) {
                int i = text.lastIndexOf("/");
                if (i >= 0) {
                    text = text.substring(i + 1);
                }
                text = text.trim();
                ((FlowElement)this.object).setName(text);
            }

            public String getDisplayName(Object context) {
                Object id;
                String name;
                String text = "";
                FlowElement flowElement = (FlowElement)this.adopt(context);
                if (this.feature.getName().equals("name")) {
                    return flowElement.getName();
                }
                EStructuralFeature f = flowElement.eClass().getEStructuralFeature("name");
                if (f != null && (name = (String)flowElement.eGet(f)) != null && !name.isEmpty()) {
                    text = name;
                }
                if (text.isEmpty() && (f = flowElement.eClass().getEStructuralFeature("id")) != null && (id = flowElement.eGet(f)) != null && !id.toString().isEmpty()) {
                    String className = flowElement.eClass().getName();
                    String idString = id.toString();
                    text = !idString.contains(className) ? String.valueOf(ModelUtil.toDisplayName((String)className)) + " '" + id + "'" : idString;
                }
                return text;
            }

            public String getChoiceString(Object context) {
                String type;
                FlowElement flowElement = (FlowElement)this.adopt(context);
                String text = flowElement.getName();
                if (text == null || text.isEmpty()) {
                    text = flowElement.getId();
                }
                EObject container = flowElement.eContainer();
                while (container != null) {
                    if (container instanceof Participant && (container = ((Participant)container).getProcessRef()) == null) break;
                    if (container instanceof Activity || container instanceof Process) {
                        text = String.valueOf(ModelUtil.getDisplayName((Object)container)) + "/" + text;
                    }
                    container = container.eContainer();
                }
                if (text != null && flowElement instanceof ItemAwareElement && (type = ModelUtil.getDisplayName((Object)((ItemAwareElement)flowElement).getItemSubjectRef())) != null) {
                    text = String.valueOf(text) + " (" + type + ")";
                }
                return text;
            }
        };
        this.setFeatureDescriptor((EStructuralFeature)f, fd);
        this.setObjectDescriptor(new ObjectDescriptor<T>(adapterFactory, (FlowElement)object){

            public void setDisplayName(String text) {
                fd.setDisplayName(text);
                ModelUtil.setID((EObject)this.object);
            }

            public String getDisplayName(Object context) {
                return fd.getDisplayName(context);
            }
        });
    }
}

