/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui;

import java.util.Enumeration;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.eclipse.bpmn2.modeler.core.IBpmn2RuntimeExtension;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.ui.IEditorInput;
import org.xml.sax.InputSource;

public class DefaultBpmn2RuntimeExtension
implements IBpmn2RuntimeExtension {
    private static final String targetNamespace = "http://org.eclipse.bpmn2/default";
    private static final String[] typeLanguages = new String[]{"http://www.w3.org/2001/XMLSchema", "XML Schema"};
    private static final String[] expressionLanguages = new String[]{"http://www.w3.org/1999/XPath", "XPath"};

    public boolean isContentForRuntime(IEditorInput input) {
        return false;
    }

    public String getTargetNamespace(ModelUtil.Bpmn2DiagramType diagramType) {
        String type = "";
        switch (diagramType) {
            case PROCESS: {
                type = "/process";
                break;
            }
            case COLLABORATION: {
                type = "/collaboration";
                break;
            }
            case CHOREOGRAPHY: {
                type = "/choreography";
                break;
            }
            default: {
                type = "/ext";
            }
        }
        return targetNamespace + type;
    }

    public String[] getTypeLanguages() {
        return typeLanguages;
    }

    public String[] getExpressionLanguages() {
        return expressionLanguages;
    }

    public void initialize(DiagramEditor editor) {
    }

    public static class AcceptedException
    extends RuntimeException {
        public String acceptedRootElement;
        private static final long serialVersionUID = 1L;

        public AcceptedException(String acceptedRootElement) {
            this.acceptedRootElement = acceptedRootElement;
        }
    }

    public static class RejectedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class RootElementParser
    extends SAXParser {
        private String namespace;
        private boolean result = false;

        public RootElementParser(String namespace) {
            this.namespace = namespace;
        }

        public boolean getResult() {
            return this.result;
        }

        public void parse(InputSource source) {
            this.result = false;
            try {
                super.parse(source);
            }
            catch (AcceptedException acceptedException) {
                this.result = true;
            }
            catch (Exception exception) {}
        }

        public void startElement(QName qName, XMLAttributes attributes, Augmentations augmentations) throws XNIException {
            super.startElement(qName, attributes, augmentations);
            if ("definitions".equals(qName.localpart)) {
                String namespace = attributes.getValue("targetNamespace");
                if (this.namespace.equals(namespace)) {
                    throw new AcceptedException(qName.localpart);
                }
                Enumeration e = this.fNamespaceContext.getAllPrefixes();
                while (e.hasMoreElements()) {
                    String prefix = (String)e.nextElement();
                    namespace = this.fNamespaceContext.getURI(prefix);
                    if (!this.namespace.equals(namespace)) continue;
                    throw new AcceptedException(qName.localpart);
                }
                throw new RejectedException();
            }
            throw new RejectedException();
        }
    }
}

