/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.ui.buildpath.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.common.jdt.core.buildpath.MaterializeLibraryJob;
import org.jboss.tools.common.jdt.ui.buildpath.dialog.MaterializeLibraryDialog;

public class MaterializeLibraryHandler
extends AbstractHandler {
    private static final String ECLIPSE_DEFAULT_WEBFOLDER = "WebContent";
    private static final String MAVEN_DEFAULT_WEBFOLDER = "src/main/webapp";
    private static final String WEB_INF = "/WEB-INF/";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ClassPathContainer libraryFromUI = this.getSelectedLibrary(selection);
        if (libraryFromUI != null) {
            IWorkbenchWindow window;
            IClasspathContainer containerToMaterialize;
            String libName;
            IJavaProject javaProject;
            block5: {
                IPath path = libraryFromUI.getClasspathEntry().getPath();
                javaProject = libraryFromUI.getJavaProject();
                libName = libraryFromUI.getLabel();
                containerToMaterialize = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject);
                window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                if (containerToMaterialize != null) break block5;
                String msg = NLS.bind((String)"The {0} classpath container is not initialized yet.", (Object)path);
                MessageDialog.openError((Shell)window.getShell(), (String)"Error Materializing library", (String)msg);
                return null;
            }
            try {
                IProject project = javaProject.getProject();
                MaterializeLibraryDialog dialog = new MaterializeLibraryDialog(window.getShell(), project, containerToMaterialize, this.getDefaultLib(project));
                if (dialog.open() == 0) {
                    Map<IPath, String> jarsToMaterialize = dialog.getSelectedClasspathEntryPaths();
                    IContainer libFolder = dialog.getLibFolder();
                    MaterializeLibraryJob job = new MaterializeLibraryJob(javaProject, containerToMaterialize, jarsToMaterialize, libFolder, dialog.isKeepSources());
                    job.setRule(this.getRule(project));
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent changeEvent) {
                            final IStatus result = changeEvent.getResult();
                            if (result.getCode() != 0) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                                        Throwable e = result.getException();
                                        if (e != null) {
                                            e.printStackTrace();
                                        }
                                        MessageDialogWithToggle.openError((Shell)shell, (String)NLS.bind((String)"Error Materializing {0}", (Object)libName), (String)result.getMessage());
                                    }
                                });
                            }
                        }
                    });
                    job.schedule();
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getDefaultLib(IProject project) {
        StringBuilder path = new StringBuilder();
        if (project.getFolder(MAVEN_DEFAULT_WEBFOLDER).exists()) {
            path.append(MAVEN_DEFAULT_WEBFOLDER).append(WEB_INF);
        } else if (project.getFolder(ECLIPSE_DEFAULT_WEBFOLDER).exists()) {
            path.append(ECLIPSE_DEFAULT_WEBFOLDER).append(WEB_INF);
        }
        path.append("lib");
        return path.toString();
    }

    private ISchedulingRule getRule(IProject project) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = ruleFactory.buildRule();
        return rule;
    }

    private ClassPathContainer getSelectedLibrary(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object o;
        ClassPathContainer container = null;
        if (selection instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ClassPathContainer) {
            container = (ClassPathContainer)o;
        }
        return container;
    }
}

