/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh.databinding;

import com.openshift.client.OpenShiftException;
import com.openshift.client.SSHPublicKey;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUserConfig;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AddSSHKeyWizardPageModel;

public class SSHPublicKeyValidator
extends MultiValidator {
    private IObservableValue filePathObservable;
    private AddSSHKeyWizardPageModel model;

    public SSHPublicKeyValidator(IObservableValue filePathObservable, AddSSHKeyWizardPageModel model) {
        this.filePathObservable = filePathObservable;
        this.model = model;
    }

    protected IStatus validate() {
        String filePath = (String)this.filePathObservable.getValue();
        if (StringUtils.isEmpty((String)filePath)) {
            return ValidationStatus.cancel((String)"You have to supply a public SSH key.");
        }
        try {
            SSHPublicKey sshPublicKey = new SSHPublicKey(filePath);
            if (this.model.hasPublicKey(sshPublicKey.getPublicKey())) {
                return ValidationStatus.error((String)("The public key in " + filePath + " is already in use on OpenShift. Choose another key."));
            }
        }
        catch (FileNotFoundException e) {
            return ValidationStatus.error((String)("Could not load file: " + e.getMessage()));
        }
        catch (OpenShiftException e) {
            return ValidationStatus.error((String)(String.valueOf(filePath) + " is not a valid public SSH key: " + e.getMessage()));
        }
        catch (IOException e) {
            return ValidationStatus.error((String)("Could not load file: " + e.getMessage()));
        }
        if (this.hasSSHConfigurationIdentityKey()) {
            return ValidationStatus.warning((String)NLS.bind((String)"Your SSH config ({0}) contains fixed keys for OpenShift servers. This can override any Eclipse specific SSH key preferences.", (Object)new SSHUserConfig(SSHUtils.getSSH2Home()).getFile()));
        }
        if (!SSHUtils.publicKeyMatchesPrivateKeyInPreferences(new File(filePath))) {
            return ValidationStatus.warning((String)NLS.bind((String)"Could not find the private key for your public key in the preferences. Make sure it is listed in the ssh2 preferences.", (Object)filePath));
        }
        return ValidationStatus.ok();
    }

    public boolean hasSSHConfigurationIdentityKey() {
        try {
            SSHUserConfig sshUserConfig = new SSHUserConfig(SSHUtils.getSSH2Home());
            return sshUserConfig.hasLibraIdentifyFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void forceRevalidate() {
        this.revalidate();
    }
}

