/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.OpenShiftException;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;

public class SSHKeysWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_KEY = "selectedSSHKey";
    public static final String PROPERTY_HAS_KEY = "hasSSHKey";
    private Connection connection;
    private IOpenShiftSSHKey selectedKey;

    public SSHKeysWizardPageModel(Connection connection) {
        this.connection = connection;
    }

    public List<IOpenShiftSSHKey> getSSHKeys() throws OpenShiftException {
        List keys = this.connection.getSSHKeys();
        this.fireHasSSHKey();
        return keys;
    }

    public IOpenShiftSSHKey getSelectedSSHKey() {
        return this.selectedKey;
    }

    public void setSelectedSSHKey(IOpenShiftSSHKey key) {
        this.selectedKey = key;
        this.firePropertyChange(PROPERTY_SELECTED_KEY, this.selectedKey, this.selectedKey);
    }

    public boolean getHasSSHKey() {
        return this.connection.hasSSHKeys();
    }

    protected void fireHasSSHKey() {
        this.firePropertyChange(PROPERTY_HAS_KEY, null, this.getHasSSHKey());
    }

    public void removeKey() throws OpenShiftException {
        if (this.selectedKey == null) {
            return;
        }
        this.selectedKey.destroy();
        this.selectedKey = null;
        this.restoreSelectedSSHKey();
    }

    public void refresh() throws OpenShiftException {
        this.connection.refresh();
        this.restoreSelectedSSHKey();
    }

    private void restoreSelectedSSHKey() {
        IOpenShiftSSHKey keyToSelect = this.selectedKey;
        if (keyToSelect == null || !this.connection.hasSSHKeyName(keyToSelect.getName())) {
            keyToSelect = this.getFirstKey();
        }
        this.setSelectedSSHKey(keyToSelect);
    }

    private IOpenShiftSSHKey getFirstKey() {
        if (this.getSSHKeys().size() == 0) {
            return null;
        }
        return this.getSSHKeys().get(0);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

