/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.markers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.marker.OpenShiftMarkers;
import org.jboss.tools.openshift.express.internal.core.util.DiffUtils;

public class ConfigureMarkersWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_AVAILABLE_MARKERS = "availableMarkers";
    public static final String PROPERTY_CHECKED_MARKERS = "checkedMarkers";
    public static final String PROPERTY_SELECTED_MARKER = "selectedMarker";
    private List<IOpenShiftMarker> availableMarkers;
    private Set<IOpenShiftMarker> presentMarkers = new HashSet<IOpenShiftMarker>();
    private Set<IOpenShiftMarker> checkedMarkers = new HashSet<IOpenShiftMarker>();
    private IOpenShiftMarker selectedMarker;
    private IProject project;

    public ConfigureMarkersWizardPageModel(IProject project) {
        this.project = project;
    }

    public void loadMarkers() throws CoreException {
        OpenShiftMarkers markers = new OpenShiftMarkers(this.project);
        this.setAvailableMarkers(markers.getAll());
        this.presentMarkers = this.toSet(markers.getPresent());
        this.setCheckedMarkers(this.presentMarkers);
    }

    private Set<IOpenShiftMarker> toSet(List<IOpenShiftMarker> markers) {
        HashSet<IOpenShiftMarker> markersSet = new HashSet<IOpenShiftMarker>();
        markersSet.addAll(markers);
        return markersSet;
    }

    public void setAvailableMarkers(List<IOpenShiftMarker> markers) {
        this.availableMarkers = markers;
        this.firePropertyChange(PROPERTY_AVAILABLE_MARKERS, this.availableMarkers, this.availableMarkers);
    }

    public List<IOpenShiftMarker> getAvailableMarkers() {
        return this.availableMarkers;
    }

    public Set<IOpenShiftMarker> getCheckedMarkers() {
        return this.checkedMarkers;
    }

    public void setCheckedMarkers(Set<IOpenShiftMarker> markers) {
        Set<IOpenShiftMarker> oldValue = this.getCheckedMarkers();
        if (markers != this.checkedMarkers) {
            this.checkedMarkers.clear();
            this.checkedMarkers.addAll(markers);
        }
        this.firePropertyChange(PROPERTY_CHECKED_MARKERS, oldValue, this.checkedMarkers);
    }

    public void setSelectedMarker(IOpenShiftMarker marker) {
        this.selectedMarker = marker;
        this.firePropertyChange(PROPERTY_SELECTED_MARKER, this.selectedMarker, this.selectedMarker);
    }

    public IOpenShiftMarker getSelectedMarker() {
        return this.selectedMarker;
    }

    public Collection<IOpenShiftMarker> getRemovedMarkers() {
        return DiffUtils.getRemovals(this.presentMarkers, this.checkedMarkers);
    }

    public Collection<IOpenShiftMarker> getAddedMarkers() {
        return DiffUtils.getAdditions(this.presentMarkers, this.checkedMarkers);
    }

    public void removeFromProject(IOpenShiftMarker marker, IProgressMonitor monitor) throws CoreException {
        if (marker == null) {
            return;
        }
        marker.removeFrom(this.project, monitor);
    }

    public IProject getProject() {
        return this.project;
    }
}

