/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.markers;

import com.openshift.client.cartridge.IEmbeddableCartridge;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.core.marker.BaseOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftProjectUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.markers.ConfigureMarkersWizardPageModel;

public class ConfigureMarkersWizardPage
extends AbstractOpenShiftWizardPage {
    private ConfigureMarkersWizardPageModel pageModel;
    private CheckboxTableViewer viewer;

    public ConfigureMarkersWizardPage(IProject project, IWizard wizard) {
        super("Configure OpenShift Markers", NLS.bind((String)"Add or remove markers to enable OpenShift features in the application {0}. \nThe markers will be created/deleted directly in {1}", (Object)OpenShiftServerUtils.getProjectAttribute((IProject)project, (String)"org.jboss.tools.openshift.ApplicationName", (String)"unknown"), (Object)OpenShiftProjectUtils.getMarkersFolder((IProject)project).getFullPath()), "ConfigureMarkers", wizard);
        this.pageModel = new ConfigureMarkersWizardPageModel(project);
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Composite tableContainer = new Composite(parent, 0);
        this.viewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).hint(-1, 250).grab(true, true).applyTo((Control)tableContainer);
        dbc.bindSet((IObservableSet)ViewerProperties.checkedElements(IOpenShiftMarker.class).observe((Viewer)this.viewer), BeanProperties.set((String)"checkedMarkers").observe((Object)this.pageModel));
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(BeanProperties.value((String)"selectedMarker").observe((Object)this.pageModel)).in(dbc);
        Group descriptionGroup = new Group(parent, 0);
        descriptionGroup.setText("Marker Description");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)descriptionGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo((Composite)descriptionGroup);
        StyledText descriptionText = new StyledText((Composite)descriptionGroup, 584);
        descriptionText.setAlwaysShowScrollBars(false);
        UIUtils.setTransparent(descriptionText);
        GridDataFactory.fillDefaults().hint(-1, 80).align(4, 4).grab(true, false).applyTo((Control)descriptionText);
        dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)this.viewer, IOpenShiftMarker.class), BeanProperties.set((String)"checkedMarkers").observe((Object)this.pageModel));
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text().observe((Widget)descriptionText)).notUpdating(BeanProperties.value((String)"selectedMarker").observe((Object)this.pageModel)).converting((IConverter)new Converter(IOpenShiftMarker.class, String.class){

            public Object convert(Object fromObject) {
                if (!(fromObject instanceof BaseOpenShiftMarker)) {
                    return null;
                }
                return ((IOpenShiftMarker)fromObject).getDescription();
            }
        })).in(dbc);
    }

    protected CheckboxTableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68384);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        viewer.setComparer((IElementComparer)new EqualityComparer());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IEmbeddableCartridge && e2 instanceof IEmbeddableCartridge) {
                    return ((IEmbeddableCartridge)e1).getDisplayName().compareTo(((IEmbeddableCartridge)e2).getDisplayName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.createTableColumn("Marker", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IOpenShiftMarker marker = (IOpenShiftMarker)cell.getElement();
                cell.setText(marker.getName());
            }
        }, (TableViewer)viewer, tableLayout);
        this.createTableColumn("File", 1, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IOpenShiftMarker marker = (IOpenShiftMarker)cell.getElement();
                cell.setText(marker.getFileName());
            }
        }, (TableViewer)viewer, tableLayout);
        return viewer;
    }

    private void createTableColumn(String name, int weight, CellLabelProvider cellLabelProvider, TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(name);
        column.setLabelProvider(cellLabelProvider);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new LoadMarkersJob(), (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDataBindingContext());
        }
        catch (Exception exception) {}
    }

    private void setViewerCheckedElements(final Collection<IOpenShiftMarker> markers) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConfigureMarkersWizardPage.this.viewer.setCheckedElements(markers.toArray());
            }
        });
    }

    private void setViewerInput(final Collection<IOpenShiftMarker> marker) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConfigureMarkersWizardPage.this.viewer.setInput((Object)marker);
            }
        });
    }

    public Collection<IOpenShiftMarker> getRemovedMarkers() {
        return this.pageModel.getRemovedMarkers();
    }

    public Collection<IOpenShiftMarker> getAddedMarkers() {
        return this.pageModel.getAddedMarkers();
    }

    private static class EqualityComparer
    implements IElementComparer {
        private EqualityComparer() {
        }

        public boolean equals(Object thisObject, Object thatObject) {
            if (thisObject == null) {
                return thatObject != null;
            }
            if (thatObject == null) {
                return false;
            }
            return thisObject.equals(thatObject);
        }

        public int hashCode(Object element) {
            return element.hashCode();
        }
    }

    private class LoadMarkersJob
    extends AbstractDelegatingMonitorJob {
        public LoadMarkersJob() {
            super("Loading markers");
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                ConfigureMarkersWizardPage.this.pageModel.loadMarkers();
                ConfigureMarkersWizardPage.this.setViewerInput(ConfigureMarkersWizardPage.this.pageModel.getAvailableMarkers());
                ConfigureMarkersWizardPage.this.setViewerCheckedElements(ConfigureMarkersWizardPage.this.pageModel.getCheckedMarkers());
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not load markers for project {0}", (Object)ConfigureMarkersWizardPage.this.pageModel.getProject().getName()), e);
            }
        }
    }
}

