/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import com.openshift.client.IApplication;
import com.openshift.client.IEnvironmentVariable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.AbstractEnvironmentVariablesWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EditEnvironmentVariablesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableItem;

public class EditEnvironmentVariablesWizard
extends AbstractEnvironmentVariablesWizard<EditEnvironmentVariablesWizardModel> {
    public EditEnvironmentVariablesWizard(IApplication application) {
        super(NLS.bind((String)"Manage Application Environment Variable(s) for application {0}", (Object)application.getName()), new EditEnvironmentVariablesWizardModel(application));
    }

    @Override
    public boolean performFinish() {
        if (!this.isSupported()) {
            return true;
        }
        IApplication application = ((EditEnvironmentVariablesWizardModel)((Object)this.getModel())).getApplication();
        try {
            WizardUtils.runInWizard((Job)new UpdateEnvironmentVariableJob(application, ((EditEnvironmentVariablesWizardModel)((Object)this.getModel())).getVariables()), (IWizardContainer)this.getContainer());
        }
        catch (InvocationTargetException e) {
            Logger.error(application == null ? "Could not edit environment variables" : NLS.bind((String)"Could not edit environment variables for application {0}", (Object)application.getName()), e);
        }
        catch (InterruptedException e) {
            Logger.error(application == null ? "Could not edit environment variables" : NLS.bind((String)"Could not edit environment variables for application {0}", (Object)application.getName()), e);
        }
        return true;
    }

    private class EnvironmentVariablesDiff {
        private List<String> removals = new ArrayList<String>();
        private List<EnvironmentVariableItem> additions = new ArrayList<EnvironmentVariableItem>();
        private List<EnvironmentVariableItem> updates = new ArrayList<EnvironmentVariableItem>();

        public EnvironmentVariablesDiff(List<EnvironmentVariableItem> editedVariables, Map<String, IEnvironmentVariable> existingVariables) {
            this.init(editedVariables, existingVariables);
        }

        private void init(List<EnvironmentVariableItem> editedVariables, Map<String, IEnvironmentVariable> existingVariables) {
            this.processAdditionsAndUpdates(editedVariables, existingVariables);
            this.processRemovals(editedVariables, existingVariables);
        }

        private void processAdditionsAndUpdates(List<EnvironmentVariableItem> editedVariables, Map<String, IEnvironmentVariable> existingVariables) {
            for (EnvironmentVariableItem variable : editedVariables) {
                IEnvironmentVariable existingVariable = existingVariables.get(variable.getName());
                if (existingVariable == null) {
                    this.additions.add(variable);
                    continue;
                }
                if (this.equals(existingVariable.getValue(), variable.getValue())) continue;
                this.updates.add(variable);
            }
        }

        private boolean equals(String thisValue, String thatValue) {
            if (thisValue == null) {
                return thatValue == null;
            }
            return thisValue.equals(thatValue);
        }

        private void processRemovals(List<EnvironmentVariableItem> editedVariables, Map<String, IEnvironmentVariable> existingVariables) {
            for (String name : existingVariables.keySet()) {
                if (this.contains(name, editedVariables)) continue;
                this.removals.add(name);
            }
        }

        private boolean contains(String name, List<EnvironmentVariableItem> editedVariables) {
            for (EnvironmentVariableItem variable : editedVariables) {
                if (!variable.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public List<EnvironmentVariableItem> getUpdates() {
            return this.updates;
        }

        public List<EnvironmentVariableItem> getAdditions() {
            return this.additions;
        }

        public List<String> getRemovals() {
            return this.removals;
        }
    }

    private class UpdateEnvironmentVariableJob
    extends AbstractDelegatingMonitorJob {
        private IApplication application;
        private List<EnvironmentVariableItem> variables;

        public UpdateEnvironmentVariableJob(IApplication application, List<EnvironmentVariableItem> variables) {
            super("Processing environment variables...");
            this.application = application;
            this.variables = variables;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            EnvironmentVariablesDiff diff = new EnvironmentVariablesDiff(this.variables, this.application.getEnvironmentVariables());
            this.remove(diff.getRemovals(), this.application);
            this.add(diff.getAdditions(), this.application);
            this.update(diff.getUpdates(), this.application);
            return Status.OK_STATUS;
        }

        private void add(List<EnvironmentVariableItem> toAdd, IApplication application) {
            for (EnvironmentVariableItem variable : toAdd) {
                application.addEnvironmentVariable(variable.getName(), variable.getValue());
            }
        }

        private void update(List<EnvironmentVariableItem> toUpdate, IApplication application) {
            for (EnvironmentVariableItem variable : toUpdate) {
                if (application.getEnvironmentVariable(variable.getName()) == null) continue;
                application.updateEnvironmentVariable(variable.getName(), variable.getValue());
            }
        }

        private void remove(List<String> namesToRemove, IApplication application) {
            for (String name : namesToRemove) {
                application.removeEnvironmentVariable(name);
            }
        }
    }
}

