/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IDomain;
import com.openshift.client.cartridge.ICartridge;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.express.internal.core.IApplicationProperties;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;

public class EmbeddedCartridgesWizardModel
extends ObservablePojo {
    private Set<ICartridge> embeddedCartridges = new HashSet<ICartridge>();
    private List<ICartridge> availableCartridges;
    private Connection connection;
    private IDomain domain;
    private IApplicationProperties applicationProperties;

    public EmbeddedCartridgesWizardModel(Set<ICartridge> embeddedCartrdiges, List<ICartridge> availableCartridges, IApplicationProperties applicationProperties, IDomain domain, Connection connection) {
        this.embeddedCartridges.addAll(embeddedCartrdiges);
        this.availableCartridges = availableCartridges;
        this.applicationProperties = applicationProperties;
        this.domain = domain;
        this.connection = connection;
    }

    public List<ICartridge> getEmbeddableCartridges() {
        return this.availableCartridges;
    }

    public Set<ICartridge> getEmbeddedCartridges() {
        return this.embeddedCartridges;
    }

    public boolean isEmbedded(ICartridge cartridge) {
        return this.embeddedCartridges.contains(cartridge);
    }

    public Set<ICartridge> setCheckedEmbeddableCartridges(Set<ICartridge> cartridges) {
        this.embeddedCartridges = cartridges;
        return this.embeddedCartridges;
    }

    public Set<ICartridge> getCheckedEmbeddableCartridges() {
        return this.embeddedCartridges;
    }

    public void refresh() {
    }

    public ApplicationScale getApplicationScale() {
        return this.applicationProperties.getApplicationScale();
    }

    public ICartridge getStandaloneCartridge() {
        return this.applicationProperties.getStandaloneCartridge();
    }

    public String getApplicationName() {
        return this.applicationProperties.getApplicationName();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public IDomain getDomain() {
        return this.domain;
    }
}

