/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.cartridge.ICartridge;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.core.CodeAnythingCartridge;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.StyleRangeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.viewer.AbstractDetailViews;

public class CartridgeDetailViews
extends AbstractDetailViews {
    private IObservableValue canModifyCartridges;
    private final AbstractDetailViews.IDetailView cartridgeView = new CartridgeDetailsView();
    private final AbstractDetailViews.IDetailView downloadableCartridgeView = new DownloadableCartridgeView();
    private final AbstractDetailViews.IDetailView codeAnythingCartridgeView = new CodeAnythingDetailsView();

    public CartridgeDetailViews(IObservableValue detailViewModel, IObservableValue canModifyCartridges, Composite parent, DataBindingContext dbc) {
        super(detailViewModel, parent, dbc);
        this.canModifyCartridges = canModifyCartridges;
    }

    @Override
    protected AbstractDetailViews.IDetailView[] getDetailViews() {
        return new AbstractDetailViews.IDetailView[]{this.codeAnythingCartridgeView, this.downloadableCartridgeView, this.cartridgeView};
    }

    private class CartridgeDetailsView
    extends AbstractDetailViews.EmptyView {
        private StyledText nameLabel;
        private StyledText description;

        private CartridgeDetailsView() {
            super(CartridgeDetailViews.this);
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(super.createControls(parent, dbc));
            GridLayoutFactory.fillDefaults().margins(10, 10).spacing(10, 10).applyTo(container);
            this.nameLabel = new StyledText(container, 8);
            UIUtils.setTransparent(this.nameLabel);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.nameLabel);
            this.description = new StyledText(container, 586);
            this.description.setAlwaysShowScrollBars(false);
            UIUtils.setTransparent(this.description);
            GridDataFactory.fillDefaults().align(16384, 4).grab(true, true).applyTo((Control)this.description);
            return container;
        }

        @Override
        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            Object value = selectedCartridgeObservable.getValue();
            if (!(value instanceof ICartridge) || DisposeUtils.isDisposed((Control)this.nameLabel)) {
                return;
            }
            ICartridge embeddableCartridge = (ICartridge)value;
            String name = OpenShiftResourceLabelUtils.toString((ICartridge)embeddableCartridge);
            this.nameLabel.setText(name);
            this.nameLabel.setStyleRange(StyleRangeUtils.createBoldStyleRange(name, null));
            this.description.setText(embeddableCartridge.getDescription());
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof ICartridge;
        }

        /* synthetic */ CartridgeDetailsView(CartridgeDetailsView cartridgeDetailsView, CartridgeDetailsView cartridgeDetailsView2) {
            this();
        }
    }

    private class CodeAnythingDetailsView
    extends CartridgeDetailsView {
        private StyledText name;
        private StyledText description;
        private Text urlText;
        private Binding binding;

        private CodeAnythingDetailsView() {
            super(null, null);
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(container);
            this.name = new StyledText(container, 8);
            GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).grab(true, false).applyTo((Control)this.name);
            this.description = new StyledText(container, 586);
            this.description.setAlwaysShowScrollBars(false);
            UIUtils.setTransparent(this.description);
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, true).applyTo((Control)this.description);
            Label urlLabel = new Label(container, 0);
            urlLabel.setText("Cartridge URL:");
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)urlLabel);
            this.urlText = new Text(container, 2048);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.urlText);
            ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.urlText)).notUpdatingParticipant()).to(CartridgeDetailViews.this.canModifyCartridges);
            return container;
        }

        @Override
        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            Object value = selectedCartridgeObservable.getValue();
            if (!(value instanceof CodeAnythingCartridge) || DisposeUtils.isDisposed((Control)this.name)) {
                return;
            }
            CodeAnythingCartridge cartridge = (CodeAnythingCartridge)value;
            String name = cartridge.getDisplayName();
            this.name.setText(name);
            this.name.setStyleRange(StyleRangeUtils.createBoldStyleRange(name, null));
            this.description.setText(cartridge.getDescription());
            ISWTObservableValue urlTextObservable = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.urlText);
            this.binding = ValueBindingBuilder.bind((IObservableValue)urlTextObservable).to(BeanProperties.value((String)"urlString", String.class).observeDetail(selectedCartridgeObservable)).in(dbc);
            CodeAnythingUrlValidator codeAnythingUrlValidator = new CodeAnythingUrlValidator((IObservableValue)urlTextObservable, selectedCartridgeObservable);
            dbc.addValidationStatusProvider((ValidationStatusProvider)codeAnythingUrlValidator);
            ControlDecorationSupport.create((ValidationStatusProvider)codeAnythingUrlValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        }

        @Override
        public void onInVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            if (DisposeUtils.isDisposed(this.binding)) {
                return;
            }
            this.binding.dispose();
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof CodeAnythingCartridge;
        }

        class CodeAnythingUrlValidator
        extends MultiValidator {
            private IObservableValue url;
            private IObservableValue selectedCartridge;

            private CodeAnythingUrlValidator(IObservableValue url, IObservableValue applicationTemplate) {
                this.url = url;
                this.selectedCartridge = applicationTemplate;
            }

            protected IStatus validate() {
                String url = (String)this.url.getValue();
                ICartridge cartridge = (ICartridge)this.selectedCartridge.getValue();
                if (!(cartridge instanceof CodeAnythingCartridge)) {
                    return ValidationStatus.ok();
                }
                if (StringUtils.isEmpty((String)url)) {
                    return ValidationStatus.cancel((String)"Please provide an url for your cartridge.");
                }
                if (!UrlUtils.isValid((String)url)) {
                    return ValidationStatus.error((String)NLS.bind((String)"{0} is not a valid url.", (Object)url));
                }
                return ValidationStatus.ok();
            }
        }
    }

    private class DownloadableCartridgeView
    extends CartridgeDetailsView {
        private StyledText name;
        private Text url;

        private DownloadableCartridgeView() {
            super(null, null);
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(10, 10).spacing(10, 10).applyTo(container);
            this.name = new StyledText(container, 8);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.name);
            this.url = new Text(container, 64);
            this.url.setEditable(false);
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.url);
            return container;
        }

        @Override
        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            Object value = selectedCartridgeObservable.getValue();
            if (!(value instanceof ICartridge) || DisposeUtils.isDisposed((Control)this.name)) {
                return;
            }
            ICartridge cartridge = (ICartridge)value;
            String cartridgeLabel = OpenShiftResourceLabelUtils.toString((ICartridge)cartridge);
            this.name.setText(cartridgeLabel);
            this.name.setStyleRange(StyleRangeUtils.createBoldStyleRange(cartridgeLabel, null));
            if (cartridge.getUrl() != null) {
                this.url.setText(cartridge.getUrl().toString());
            }
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof ICartridge && ((ICartridge)object).isDownloadable();
        }
    }
}

