/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.cartridge.ICartridge;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardPageModel;

public abstract class AbstractCheckEmbeddableCartridgeStrategy
implements ICheckStateListener {
    private EmbeddedCartridgesWizardPageModel pageModel;
    private IWizardPage wizardPage;

    protected AbstractCheckEmbeddableCartridgeStrategy(EmbeddedCartridgesWizardPageModel pageModel, IWizardPage wizardPage) {
        this.pageModel = pageModel;
        this.wizardPage = wizardPage;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Assert.isLegal((boolean)(event.getElement() instanceof ICartridge));
        ICartridge cartridge = (ICartridge)event.getElement();
        if (event.getChecked()) {
            this.add(cartridge, event);
        } else {
            this.remove(cartridge, event);
        }
    }

    protected abstract void add(ICartridge var1, CheckStateChangedEvent var2);

    protected abstract void remove(ICartridge var1, CheckStateChangedEvent var2);

    protected int openQuestionDialog(String title, String message) {
        return new MessageDialog(this.getShell(), title, null, message, 3, new String[]{"No", "Yes"}, 0).open();
    }

    protected EmbeddedCartridgesWizardPageModel getPageModel() {
        return this.pageModel;
    }

    protected Shell getShell() {
        return this.wizardPage.getControl().getShell();
    }

    protected IWizardContainer getContainer() {
        return this.wizardPage.getWizard().getContainer();
    }
}

