/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.OpenshiftUIMessages;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.EditDomainWizardModel;

public class EditDomainWizardPage
extends AbstractOpenShiftWizardPage {
    private EditDomainWizardModel pageModel;

    public EditDomainWizardPage(String title, String description, EditDomainWizardModel model, IWizard wizard) {
        super(title, description, "", wizard);
        this.pageModel = model;
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(parent);
        Label namespaceLabel = new Label(parent, 0);
        namespaceLabel.setText(OpenshiftUIMessages.DomainName);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)namespaceLabel);
        Text namespaceText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)namespaceText);
        ISWTObservableValue namespaceTextObservable = WidgetProperties.text((int)24).observe((Widget)namespaceText);
        NamespaceValidator namespaceValidator = new NamespaceValidator(namespaceTextObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)namespaceValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)namespaceValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        IObservableValue namespaceModelObservable = BeanProperties.value((String)"domainId").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)namespaceTextObservable).to(namespaceModelObservable).in(dbc);
        Link editMembersLink = new Link(parent, 0);
        editMembersLink.setText("<a>Edit domain members</a>");
        GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).applyTo((Control)editMembersLink);
        editMembersLink.addSelectionListener(this.onEditMembers());
    }

    private SelectionListener onEditMembers() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final GetUrlJob getURLJob = new GetUrlJob();
                new JobChainBuilder((Job)getURLJob).runWhenSuccessfullyDone((Job)new UIJob("Open Browser to Edit domain members"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        String webUIDomainPage = getURLJob.getWebUIDomainPageUrl();
                        if (webUIDomainPage != null) {
                            new BrowserUtility().checkedCreateExternalBrowser(webUIDomainPage, "org.jboss.tools.openshift.express.ui", OpenShiftUIActivator.getDefault().getLog());
                        } else {
                            new WebUIDomainPageNotFoundDialog(EditDomainWizardPage.this.getShell(), EditDomainWizardPage.this.pageModel.getOriginWebUIDomainPageUrl()).open();
                        }
                        return Status.OK_STATUS;
                    }
                }).schedule();
            }
        };
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    private class GetUrlJob
    extends Job {
        private String webUIDomainPageUrl;

        public GetUrlJob() {
            super("Get Domain Web UI URL");
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.webUIDomainPageUrl = EditDomainWizardPage.this.pageModel.getWebUIDomainPageUrl();
            return Status.OK_STATUS;
        }

        public String getWebUIDomainPageUrl() {
            return this.webUIDomainPageUrl;
        }
    }

    class NamespaceValidator
    extends MultiValidator {
        private final ISWTObservableValue domainNameObservable;

        public NamespaceValidator(ISWTObservableValue domainNameObservable) {
            this.domainNameObservable = domainNameObservable;
        }

        protected IStatus validate() {
            String domainName = (String)this.domainNameObservable.getValue();
            if (EditDomainWizardPage.this.pageModel.isCurrentDomainId(domainName)) {
                return ValidationStatus.cancel((String)EditDomainWizardPage.this.getDescription());
            }
            if (domainName.isEmpty()) {
                return ValidationStatus.cancel((String)OpenshiftUIMessages.EnterDomainName);
            }
            if (!StringUtils.isAlphaNumeric((String)domainName)) {
                return ValidationStatus.error((String)OpenshiftUIMessages.DomainNameMayHaveLettersAndDigits);
            }
            if (domainName.length() > 16) {
                return ValidationStatus.error((String)OpenshiftUIMessages.DomainNameMaximumLength);
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.domainNameObservable);
            return targets;
        }
    }

    private class WebUIDomainPageNotFoundDialog
    extends MessageDialog {
        private String webUIDomainPageUrl;

        public WebUIDomainPageNotFoundDialog(Shell parentShell, String webUIDomainPageUrl) {
            super(parentShell, "Could not find web console", null, "Could not find the web page in the web console where you can edit your domain members.\nTo get there manually, please log into the web console and open the page that shows the details of your domain.\nThe url normally looks as follows:", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.webUIDomainPageUrl = webUIDomainPageUrl;
        }

        protected Control createCustomArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(container);
            Link link = new Link(container, 0);
            link.setText("<a>" + this.webUIDomainPageUrl + "</a>");
            link.addSelectionListener(this.onLinkClicked(this.webUIDomainPageUrl));
            GridDataFactory.fillDefaults().indent(60, 0).applyTo((Control)link);
            return container;
        }

        private SelectionListener onLinkClicked(final String webUIDomainPageUrl) {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new BrowserUtility().checkedCreateExternalBrowser(webUIDomainPageUrl, "org.jboss.tools.openshift.express.ui", OpenShiftUIActivator.getDefault().getLog());
                }
            };
        }
    }
}

