/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.IDomain;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class EditDomainWizardModel
extends ObservableUIPojo {
    public static final String PROPERTY_DOMAIN_ID = "domainId";
    private static final String OPENSHIFT_ENTERPRISE_WEBUI_DOMAINPAGE = "{0}/console/domain/{1}";
    private static final String OPENSHIFT_ORIGIN_WEBUI_DOMAINPAGE = "{0}/app/console/domain/{1}";
    private String domainId;
    private final IDomain domain;
    private Connection connection;

    public EditDomainWizardModel(Connection connection) {
        this(null, connection);
    }

    public EditDomainWizardModel(IDomain domain) {
        this(domain, null);
    }

    protected EditDomainWizardModel(IDomain domain, Connection connection) {
        this.domain = domain;
        this.connection = connection;
        if (domain == null) {
            return;
        }
        this.setDomainId(domain.getId());
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
        this.firePropertyChange(PROPERTY_DOMAIN_ID, this.domainId, this.domainId);
    }

    public void renameDomain() throws OpenShiftException, SocketTimeoutException {
        if (this.domain == null) {
            Logger.warn("Attempting to rename missing user domain...");
            return;
        }
        this.domain.rename(this.domainId);
        this.fireConnectionChanged(this.domain, this.connection);
    }

    private void fireConnectionChanged(IDomain domain, Connection connection) {
        if (connection != null) {
            ConnectionsModelSingleton.getInstance().fireConnectionChanged(connection);
        } else if (domain != null) {
            ConnectionsModelSingleton.getInstance().fireConnectionChanged(domain.getUser());
        }
    }

    public boolean isCurrentDomainId(String domainId) {
        block3: {
            try {
                if (this.domain != null) break block3;
                return false;
            }
            catch (Exception e) {
                OpenShiftUIActivator.log(e);
                return true;
            }
        }
        return this.domain.getId().equals(domainId);
    }

    public IDomain getDomain() {
        return this.domain;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getWebUIDomainPageUrl() {
        if (this.getDomain() == null || this.getDomain().getUser() == null) {
            return null;
        }
        String domainWebUIUrl = this.getOriginWebUIDomainPageUrl();
        if (this.isUrlAvailable(domainWebUIUrl)) {
            return domainWebUIUrl;
        }
        domainWebUIUrl = this.getEnterpsiseWebUIDomainPageUrl();
        if (this.isUrlAvailable(domainWebUIUrl)) {
            return domainWebUIUrl;
        }
        return null;
    }

    public String getOriginWebUIDomainPageUrl() {
        if (this.getDomain() == null) {
            return null;
        }
        String host = this.getDomain().getUser().getServer();
        return MessageFormat.format(OPENSHIFT_ORIGIN_WEBUI_DOMAINPAGE, host, this.domainId);
    }

    public String getEnterpsiseWebUIDomainPageUrl() {
        if (this.getDomain() == null) {
            return null;
        }
        String host = this.getDomain().getUser().getServer();
        return MessageFormat.format(OPENSHIFT_ENTERPRISE_WEBUI_DOMAINPAGE, host, this.domainId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUrlAvailable(String domainWebUIUrl) {
        try {
            URL url = new URL(domainWebUIUrl);
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                if (connection instanceof HttpsURLConnection) {
                    UrlUtils.setupPermissiveSSLHandlers((HttpsURLConnection)((HttpsURLConnection)connection));
                }
                IUser user = this.getDomain().getUser();
                UrlUtils.addBasicAuthorization((String)user.getRhlogin(), (String)user.getPassword(), (HttpURLConnection)connection);
                connection.connect();
                return connection.getResponseCode() == 200;
            }
            catch (KeyManagementException e) {
                OpenShiftUIActivator.log(NLS.bind((String)"Could not install permissive trust manager and hostname verifier for connection {0}", (Object)url), e);
                return false;
            }
            catch (NoSuchAlgorithmException e) {
                OpenShiftUIActivator.log(NLS.bind((String)"Could not install permissive trust manager and hostname verifier for connection {0}", (Object)url), e);
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }
}

