/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftEndpointException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.EditDomainWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.EditDomainWizardPage;

public class EditDomainWizard
extends AbstractOpenShiftWizard<EditDomainWizardModel> {
    public EditDomainWizard(IDomain domain) {
        super("Edit domain", new EditDomainWizardModel(domain));
    }

    @Override
    public boolean performFinish() {
        AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Renaming domain..."){

            @Override
            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    ((EditDomainWizardModel)((Object)EditDomainWizard.this.getModel())).renameDomain();
                    return Status.OK_STATUS;
                }
                catch (OpenShiftEndpointException e) {
                    return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not rename domain \"{0}\": {1}", (Object)((EditDomainWizardModel)((Object)EditDomainWizard.this.getModel())).getDomainId(), (Object)e.getRestResponseMessages()), e);
                }
                catch (Exception e) {
                    return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not rename domain {0}", (Object)((EditDomainWizardModel)((Object)EditDomainWizard.this.getModel())).getDomainId()), e);
                }
            }
        };
        try {
            IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            return status.isOK();
        }
        catch (Exception ex) {
            Logger.error("Could not rename domain", ex);
            return false;
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)new EditDomainWizardPage("OpenShift Domain Name", "Please provide a new name for your OpenShift domain", (EditDomainWizardModel)((Object)this.getModel()), (IWizard)this));
    }
}

