/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.template;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import org.jboss.tools.openshift.express.core.CodeAnythingCartridge;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.CartridgeApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICodeAnythingApplicationTemplate;

public class CodeAnythingApplicationTemplate
extends CartridgeApplicationTemplate
implements ICodeAnythingApplicationTemplate {
    public CodeAnythingApplicationTemplate() {
        super((IStandaloneCartridge)new CodeAnythingCartridge());
    }

    @Override
    public boolean isCodeAnything() {
        return true;
    }

    @Override
    public String getUrl() {
        return this.getCartridgeUrl((CodeAnythingCartridge)this.getStandaloneCartridge());
    }

    @Override
    public void setUrl(String url) {
        String oldUrl = this.getUrl();
        ((CodeAnythingCartridge)this.getStandaloneCartridge()).setUrlString(url);
        this.firePropertyChange("url", oldUrl, url);
        String oldName = this.getName();
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder(super.getName());
        String cartridgeUrl = this.getCartridgeUrl((CodeAnythingCartridge)this.getStandaloneCartridge());
        if (!StringUtils.isEmpty((String)cartridgeUrl)) {
            builder.append(" (").append(cartridgeUrl).append(')');
        }
        return builder.toString();
    }

    protected String getCartridgeUrl(CodeAnythingCartridge cartridge) {
        if (cartridge == null || cartridge.getUrlString() == null) {
            return null;
        }
        return cartridge.getUrlString();
    }

    @Override
    public boolean isMatching(String expression) {
        if (super.isMatching(expression)) {
            return true;
        }
        ICartridge cartridge = this.getStandaloneCartridge();
        if (cartridge == null) {
            return false;
        }
        String lowerCaseExpression = StringUtils.toLowerCase((String)expression);
        return this.isMatching(lowerCaseExpression, StringUtils.toLowerCase((String)cartridge.getName())) || this.isMatching(lowerCaseExpression, StringUtils.toLowerCase((String)cartridge.getDisplayName())) || this.isMatching(lowerCaseExpression, StringUtils.toLowerCase((String)cartridge.getDescription()));
    }
}

