/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.project;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.project.AbstractProjectImportOperation;

public class GeneralProjectImportOperation
extends AbstractProjectImportOperation {
    public GeneralProjectImportOperation(File projectDirectory) {
        super(projectDirectory);
    }

    public List<IProject> importToWorkspace(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getProjectDirectory().getName());
        this.overwriteExistingProject(project, workspace, monitor);
        this.importToWorkspace(this.getProjectDirectory(), workspace, monitor);
        return Collections.singletonList(project);
    }

    private void importToWorkspace(File projectDirectory, IWorkspace workspace, IProgressMonitor monitor) throws CoreException {
        String projectName = projectDirectory.getName();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocation(Path.fromOSString((String)projectDirectory.getAbsolutePath()));
        IProject project = workspace.getRoot().getProject(projectName);
        project.create(description, monitor);
        project.open(128, monitor);
    }

    private void overwriteExistingProject(final IProject project, IWorkspace workspace, IProgressMonitor monitor) throws CoreException {
        if (project == null || !project.exists()) {
            return;
        }
        final boolean[] overwrite = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                overwrite[0] = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Overwrite project?", (String)NLS.bind((String)"A project \"{0}\" already exists in the workspace.\nIf you want to import the OpenShift \"{0}\", the project in your workspace will get overwritten and may not be recovered.\n\nAre you sure that you want to overwrite the project \"{0}\" in your workspace?", (Object)project.getName()));
            }
        });
        if (overwrite[0]) {
            project.delete(true, true, monitor);
        }
    }
}

