/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpenShiftMavenProfile {
    private static final String POM_FILENAME = "pom.xml";
    private static final String ID_OPENSHIFT = "openshift";
    private static final String ELEMENT_PROJECT = "project";
    private static final String ELEMENT_PROFILES = "profiles";
    private static final String ELEMENT_PROFILE = "profile";
    private static final String ELEMENT_ID = "id";
    private static final String OPENSHIFT_WAR_PROFILE = "<profile>\n<!-- When built in OpenShift the 'openshift' profile will be used when invoking mvn. -->\n<!-- Use this profile for any OpenShift specific customization your app will need. -->\n<!-- By default that is to put the resulting archive into the 'deployments' folder. -->\n<!-- http://maven.apache.org/guides/mini/guide-building-for-different-environments.html -->\n<id>openshift</id>\n<build>\n   <finalName>{0}</finalName>\n   <plugins>\n     <plugin>\n       <artifactId>maven-war-plugin</artifactId>\n       <version>2.4</version>\n       <configuration>\n         <outputDirectory>{1}</outputDirectory>\n         <warName>ROOT</warName>\n       </configuration>\n     </plugin>\n   </plugins>\n </build>\n</profile>\n";
    private static final String OPENSHIFT_MULTIPROJECT_WAR_PROFILE = "<profile>\n<!-- When built in OpenShift the 'openshift' profile will be used when invoking mvn. -->\n<!-- Use this profile for any OpenShift specific customization your app will need. -->\n<!-- By default that is to put the resulting archive into the 'deployments' folder. -->\n<!-- http://maven.apache.org/guides/mini/guide-building-for-different-environments.html -->\n<id>openshift</id>\n<build>\n   <finalName>{0}</finalName>\n   <plugins>\n     <plugin>\n       <artifactId>maven-war-plugin</artifactId>\n       <version>2.4</version>\n       <configuration>\n         <outputDirectory>deployments</outputDirectory>\n       </configuration>\n     </plugin>\n   </plugins>\n </build>\n</profile>\n";
    private static final String OPENSHIFT_EAR_PROFILE = "<profile>\n<!-- When built in OpenShift the 'openshift' profile will be used when invoking mvn. -->\n<!-- Use this profile for any OpenShift specific customization your app will need. -->\n<!-- By default that is to put the resulting archive into the 'deployments' folder. -->\n<!-- http://maven.apache.org/guides/mini/guide-building-for-different-environments.html -->\n<id>openshift</id>\n  <build>\n    <pluginManagement>\n      <plugins>\n        <plugin>\n\t         <artifactId>maven-ear-plugin</artifactId>\n\t         <version>2.7</version>\n\t         <configuration>\n\t           <outputDirectory>deployments</outputDirectory>\n\t         </configuration>\n        </plugin>\n      </plugins>\n    </pluginManagement>\n  </build>\n</profile>\n";
    private IFile pomFile;
    private String pluginId;
    private Document document;

    public OpenShiftMavenProfile(IProject project, String pluginId) {
        this(project.getFile(POM_FILENAME), pluginId);
    }

    public OpenShiftMavenProfile(IFile pomFile, String pluginId) {
        this.pomFile = pomFile;
        this.pluginId = pluginId;
    }

    public boolean existsInPom() throws CoreException {
        if (!this.exists(this.pomFile)) {
            return false;
        }
        Element openShiftProfileElement = this.getOpenShiftProfileElement(this.getDocument());
        return openShiftProfileElement != null;
    }

    public boolean addToPom(String finalName, String outputDirectory) throws CoreException {
        block5: {
            if (!this.existsInPom()) break block5;
            return false;
        }
        try {
            Document document = this.getDocument();
            Element profilesElement = this.getOrCreateProfilesElement(document);
            Node profileNode = document.importNode(this.createOpenShiftProfileElement(finalName, outputDirectory), true);
            profilesElement.appendChild(profileNode);
            return true;
        }
        catch (SAXException e) {
            throw new CoreException(this.createStatus(e));
        }
        catch (IOException e) {
            throw new CoreException(this.createStatus(e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(this.createStatus(e));
        }
    }

    private Element createOpenShiftProfileElement(String finalName, String outputDirectory) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        String openShiftProfile = MessageFormat.format(this.getProfileTemplate(), finalName, outputDirectory);
        Document document = documentBuilder.parse(new ByteArrayInputStream(openShiftProfile.getBytes()));
        return document.getDocumentElement();
    }

    private String getProfileTemplate() {
        return OPENSHIFT_WAR_PROFILE;
    }

    private Element getOrCreateProfilesElement(Document document) throws CoreException {
        Element profilesElement = this.getProfilesElement(document);
        if (profilesElement == null) {
            profilesElement = this.createProfilesElement(document);
        }
        return profilesElement;
    }

    private Element createProfilesElement(Document document) throws CoreException {
        Element profilesElement = document.createElement(ELEMENT_PROFILES);
        Element projectElement = this.getProjectElement(document);
        if (projectElement == null) {
            throw new CoreException(this.createStatus(NLS.bind((String)"Could not find <project> tag in pom {0}", (Object)this.pomFile.toString())));
        }
        projectElement.appendChild(profilesElement);
        return profilesElement;
    }

    private boolean exists(IFile file) {
        return file != null && file.exists();
    }

    private Element getProfilesElement(Document document) {
        return this.getFirstElement(ELEMENT_PROFILES, document);
    }

    private Element getProjectElement(Document document) {
        return this.getFirstElement(ELEMENT_PROJECT, document);
    }

    private Element getOpenShiftProfileElement(Document document) {
        return this.getOpenShiftProfileElement(this.getProfilesElement(document));
    }

    private Element getOpenShiftProfileElement(Element element) {
        Element openshiftProfile = this.getFirstElementByMatcher(ELEMENT_PROFILE, new IMatcher(){

            @Override
            public boolean isMatch(Element element) {
                if (element == null) {
                    return false;
                }
                Element idElement = OpenShiftMavenProfile.this.getFirstElement(OpenShiftMavenProfile.ELEMENT_ID, element);
                if (idElement == null) {
                    return false;
                }
                if (idElement.hasChildNodes()) {
                    return OpenShiftMavenProfile.ID_OPENSHIFT.equals(idElement.getFirstChild().getTextContent());
                }
                return false;
            }
        }, element);
        return openshiftProfile;
    }

    private Element getFirstElement(String elementName, Document document) {
        NodeList elements = document.getElementsByTagName(elementName);
        if (elements != null && elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    protected Element getFirstElement(String elementName, Element element) {
        NodeList children = element.getElementsByTagName(elementName);
        if (children == null || children.getLength() == 0) {
            return null;
        }
        return (Element)children.item(0);
    }

    protected Element getFirstElementByMatcher(String elementName, IMatcher matcher, Element element) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getElementsByTagName(elementName);
        if (children == null || children.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            if (matcher.isMatch(child)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    private Document getDocument() throws CoreException {
        try {
            if (this.document == null) {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.document = documentBuilder.parse(this.pomFile.getContents());
            }
            return this.document;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(this.createStatus(e));
        }
        catch (SAXException e) {
            throw new CoreException(this.createStatus(e));
        }
        catch (IOException e) {
            throw new CoreException(this.createStatus(e));
        }
    }

    private IStatus createStatus(Throwable e) {
        return new Status(4, this.pluginId, e.getMessage(), e);
    }

    private IStatus createStatus(String message) {
        return new Status(4, this.pluginId, message);
    }

    public IFile savePom(IProgressMonitor monitor) throws CoreException {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            this.createTransformer().transform(new DOMSource(this.getDocument()), new StreamResult(writer));
            this.pomFile.setContents((InputStream)new ByteArrayInputStream(((Object)writer).toString().getBytes()), 1, monitor);
            IFile iFile = this.pomFile;
            return iFile;
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException(this.createStatus(e));
        }
        catch (TransformerException e) {
            throw new CoreException(this.createStatus(e));
        }
        finally {
            this.safeClose(writer);
        }
    }

    private Transformer createTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", new Integer(4));
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        return transformer;
    }

    private void safeClose(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {}
    }

    public static boolean isMavenProject(IProject project) {
        return project.getFile(POM_FILENAME).exists();
    }

    private static interface IMatcher {
        public boolean isMatch(Element var1);
    }
}

