/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.util.FileUtils;
import org.jboss.tools.openshift.express.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.AbstractImportApplicationOperation;

public class MergeIntoUnsharedProject
extends AbstractImportApplicationOperation {
    public MergeIntoUnsharedProject(String projectName, IApplication application, String remoteName, List<IOpenShiftMarker> markers, Connection connection) {
        super(projectName, application, remoteName, markers, connection);
    }

    @Override
    public IProject execute(IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, IOException, CoreException, URISyntaxException {
        IProject project = this.getProject();
        this.copyOpenshiftConfigurations(this.getApplication(), this.getRemoteName(), project, monitor);
        this.setupGitIgnore(project, monitor);
        this.setupOpenShiftMavenProfile(this.getApplication(), project, monitor);
        this.addSettingsFile(project, monitor);
        this.setupMarkers(project, monitor);
        this.shareProject(project, monitor);
        this.addRemote(this.getRemoteName(), this.getApplication().getGitUrl(), project);
        return project;
    }

    private void shareProject(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(NLS.bind((String)"Sharing project {0}...", (Object)project.getName()));
        EGitUtils.share((IProject)project, (IProgressMonitor)monitor);
    }

    private void copyOpenshiftConfigurations(IApplication application, String remoteName, IProject project, IProgressMonitor monitor) throws IOException, OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException, CoreException {
        Assert.isLegal((project != null ? 1 : 0) != 0);
        monitor.subTask(NLS.bind((String)"Copying openshift configuration to project {0}...", (Object)project.getName()));
        File tmpFolder = FileUtils.getRandomTmpFolder();
        this.cloneRepository(this.getApplication(), this.getRemoteName(), tmpFolder, false, monitor);
        ResourceUtils.copy((File)tmpFolder, (String[])new String[]{".git", ".openshift", "deployments", "pom.xml"}, (IProject)project, (IProgressMonitor)monitor);
        FileUtil.safeDelete((File)tmpFolder);
    }
}

