/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.util.ProjectUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.IOpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ProjectAndServerAdapterSettingsWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.SelectExistingProjectDialog;

public class ProjectAndServerAdapterSettingsWizardPage
extends AbstractOpenShiftWizardPage {
    public static final String PREF_CONTENTASSISTKEY = "prefContentAssistKey";
    private static final String PAGE_DESCRIPTION_PATTERN = "Configure your project and server adapter settings for application \"{0}\".";
    private ProjectAndServerAdapterSettingsWizardPageModel pageModel;

    public ProjectAndServerAdapterSettingsWizardPage(IWizard wizard, IOpenShiftApplicationWizardModel wizardModel) {
        super("Set up Project for new OpenShift Application", NLS.bind((String)PAGE_DESCRIPTION_PATTERN, (Object)wizardModel.getApplicationName()), "Project Configuration", wizard);
        this.pageModel = new ProjectAndServerAdapterSettingsWizardPageModel(wizardModel);
    }

    @Override
    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(container);
        this.createProjectControls(container, dbc);
        this.createServerAdapterControls(container, dbc);
    }

    private Composite createProjectControls(Composite parent, DataBindingContext dbc) {
        Composite projectComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)projectComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(projectComposite);
        Button newProjectCheckbox = new Button(projectComposite, 32);
        newProjectCheckbox.setText("Create a new project");
        newProjectCheckbox.setToolTipText("The OpenShift application code will be pulled into the newly created project or merged into the selected one.");
        newProjectCheckbox.setFocus();
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(false, false).applyTo((Control)newProjectCheckbox);
        IObservableValue newProjectModelObservable = BeanProperties.value((String)"newProject").observe((Object)this.pageModel);
        ISWTObservableValue newProjectCheckboxObservable = WidgetProperties.selection().observe((Widget)newProjectCheckbox);
        ValueBindingBuilder.bind((IObservableValue)newProjectCheckboxObservable).to(newProjectModelObservable).in(dbc);
        Label existingProjectLabel = new Label(projectComposite, 0);
        existingProjectLabel.setText("Use existing project:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).indent(10, 0).applyTo((Control)existingProjectLabel);
        final Text existingProjectNameText = new Text(projectComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)existingProjectNameText);
        ISWTObservableValue projectNameTextObservable = WidgetProperties.text((int)24).observe((Widget)existingProjectNameText);
        ValueBindingBuilder.bind((IObservableValue)projectNameTextObservable).to(BeanProperties.value((String)"projectName").observe((Object)this.pageModel)).in(dbc);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)existingProjectNameText)).notUpdating(newProjectModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        newProjectCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                existingProjectNameText.setFocus();
                existingProjectNameText.selectAll();
            }
        });
        ControlDecoration dec = new ControlDecoration((Control)existingProjectNameText, 16512);
        FieldDecoration contentProposalFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        dec.setImage(contentProposalFieldIndicator.getImage());
        dec.setDescriptionText("Auto-completion is enabled when you start typing a project name.");
        dec.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)existingProjectNameText, (IControlContentAdapter)new TextContentAdapter(), ProjectUtils.getAllOpenedProjects());
        Button browseProjectsButton = new Button(projectComposite, 0);
        browseProjectsButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).grab(false, false).applyTo((Control)browseProjectsButton);
        browseProjectsButton.addSelectionListener(this.onBrowseProjects());
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)browseProjectsButton)).notUpdating(newProjectModelObservable).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        IObservableValue applicationNameModelObservable = BeanProperties.value((String)"applicationName").observe((Object)this.pageModel);
        NewProjectValidator newProjectValidator = new NewProjectValidator((IObservableValue)newProjectCheckboxObservable, applicationNameModelObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)newProjectValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)newProjectValidator, (int)16512);
        ExistingProjectValidator existingProjectValidator = new ExistingProjectValidator((IObservableValue)newProjectCheckboxObservable, (IObservableValue)projectNameTextObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)existingProjectValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)existingProjectValidator, (int)16512);
        return projectComposite;
    }

    private SelectionListener onBrowseProjects() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedProject;
                SelectExistingProjectDialog dialog = new SelectExistingProjectDialog(ProjectAndServerAdapterSettingsWizardPage.this.pageModel.getApplicationName(), ProjectAndServerAdapterSettingsWizardPage.this.getShell());
                if (dialog.open() == 0 && (selectedProject = dialog.getFirstResult()) instanceof IProject) {
                    ProjectAndServerAdapterSettingsWizardPage.this.pageModel.setProjectName(((IProject)selectedProject).getName());
                }
            }
        };
    }

    private void createServerAdapterControls(Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(12, 8).margins(6, 6).applyTo(container);
        Button serverAdapterCheckbox = new Button(container, 32);
        serverAdapterCheckbox.setText("Create and set up a server for easy publishing");
        serverAdapterCheckbox.setToolTipText("This Server Adapter will let you publish your local changes onto OpenShift, right from your Eclipse workbench.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)serverAdapterCheckbox);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)serverAdapterCheckbox)).to(BeanProperties.value((String)"createServerAdapter").observe((Object)this.pageModel)).in(dbc);
        Button skipMavenBuildCheckbox = new Button(container, 32);
        skipMavenBuildCheckbox.setText("Disable automatic maven build when pushing to OpenShift");
        skipMavenBuildCheckbox.setToolTipText("Configures the project to not get built when pushed to OpenShift.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)skipMavenBuildCheckbox);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)skipMavenBuildCheckbox)).to(BeanProperties.value((String)"skipMavenBuild").observe((Object)this.pageModel)).in(dbc);
    }

    @Override
    protected void onPageWillGetActivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event, DataBindingContext dbc) {
        if (direction == AbstractOpenShiftWizardPage.Direction.FORWARDS) {
            this.pageModel.reset();
        }
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        this.setPageDescription();
        dbc.updateTargets();
    }

    private void setPageDescription() {
        this.setDescription(NLS.bind((String)PAGE_DESCRIPTION_PATTERN, (Object)this.pageModel.getApplicationName()));
    }

    class ExistingProjectValidator
    extends MultiValidator {
        private final IObservableValue newProjectObservable;
        private final IObservableValue projectNameObservable;

        public ExistingProjectValidator(IObservableValue newProjectObservable, IObservableValue projectNameObservable) {
            this.newProjectObservable = newProjectObservable;
            this.projectNameObservable = projectNameObservable;
        }

        public IStatus validate() {
            String projectName = (String)this.projectNameObservable.getValue();
            Boolean isNewProject = (Boolean)this.newProjectObservable.getValue();
            IStatus status = ValidationStatus.ok();
            if (!isNewProject.booleanValue()) {
                if (StringUtils.isEmpty((String)projectName)) {
                    status = ValidationStatus.cancel((String)"Select an open project in the workspace.");
                } else {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (!ProjectUtils.exists((IProject)project)) {
                        status = ValidationStatus.error((String)NLS.bind((String)"The project {0} does not exist in your workspace.", (Object)projectName));
                    } else if (!ProjectUtils.isAccessible((IProject)project)) {
                        status = ValidationStatus.error((String)NLS.bind((String)"The project {0} is not open.", (Object)projectName));
                    } else if (EGitUtils.isSharedWithGit((IProject)project)) {
                        status = this.getGitDirtyStatus(project);
                    }
                }
            }
            return status;
        }

        private IStatus getGitDirtyStatus(IProject project) {
            IStatus repoCorruptError = ValidationStatus.error((String)NLS.bind((String)"The git repository for project {0} looks corrupt. Please fix it before using it.", (Object)project.getName()));
            try {
                if (EGitUtils.isDirty((IProject)project, (boolean)false)) {
                    return ValidationStatus.error((String)NLS.bind((String)"The project {0} has uncommitted changes. Please commit those changes first.", (Object)project.getName()));
                }
                return ValidationStatus.ok();
            }
            catch (NoWorkTreeException noWorkTreeException) {
                return repoCorruptError;
            }
            catch (IOException iOException) {
                return repoCorruptError;
            }
            catch (GitAPIException gitAPIException) {
                return repoCorruptError;
            }
        }

        public IObservableList getTargets() {
            return Observables.staticObservableList(Collections.singletonList(this.projectNameObservable));
        }
    }

    class NewProjectValidator
    extends MultiValidator {
        private final IObservableValue applicationNameObservable;
        private final IObservableValue newProjectObservable;

        public NewProjectValidator(IObservableValue newProjectObservable, IObservableValue applicationNameObservable) {
            this.newProjectObservable = newProjectObservable;
            this.applicationNameObservable = applicationNameObservable;
        }

        public IStatus validate() {
            Boolean isNewProject = (Boolean)this.newProjectObservable.getValue();
            String applicationName = (String)this.applicationNameObservable.getValue();
            IStatus status = ValidationStatus.ok();
            if (isNewProject.booleanValue()) {
                if (StringUtils.isEmptyOrNull((String)applicationName)) {
                    status = ValidationStatus.cancel((String)"You have to choose an application name");
                } else if (!StringUtils.isAlphaNumeric((String)applicationName)) {
                    status = ValidationStatus.error((String)"The name may only contain letters and digits.");
                } else {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(applicationName);
                    if (ProjectUtils.exists((IProject)project)) {
                        status = ValidationStatus.error((String)NLS.bind((String)"A project named {0} already exists in the workspace. Delete, rename or merge use it as existing project", (Object)applicationName));
                    }
                }
            }
            return status;
        }
    }
}

