/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.IApplication;
import com.openshift.client.NotFoundOpenShiftException;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ApplicationTemplateDetailViews;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ApplicationTemplateWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.SelectApplicationWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICartridgeApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IQuickstartApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.NewDomainWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.NoSSHKeysWizard;

public class ApplicationTemplateWizardPage
extends AbstractOpenShiftWizardPage {
    private ApplicationTemplateWizardPageModel pageModel;
    private Text existingAppNameText;
    private OpenShiftApplicationWizardModel wizardModel;

    ApplicationTemplateWizardPage(IWizard wizard, OpenShiftApplicationWizardModel wizardModel) {
        super("Existing or new application", "", "Select an existing or create a new application", wizard);
        this.wizardModel = wizardModel;
        this.pageModel = new ApplicationTemplateWizardPageModel(this.wizardModel);
    }

    @Override
    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        this.setWizardPageDescription(this.pageModel.isUseExistingApplication());
        SelectObservableValue useExitingApplication = new SelectObservableValue();
        ValueBindingBuilder.bind((IObservableValue)useExitingApplication).to(BeanProperties.value((String)"useExistingApplication").observe((Object)this.pageModel)).in(dbc);
        IObservableValue useExistingApplicationObservable = BeanProperties.value((String)"useExistingApplication").observe((Object)this.pageModel);
        this.createExistingApplicationControls(container, useExitingApplication, useExistingApplicationObservable, dbc);
        this.createNewApplicationControls(container, useExitingApplication, useExistingApplicationObservable, dbc);
    }

    private void createExistingApplicationControls(Composite parent, SelectObservableValue useExitingApplication, IObservableValue useExistingApplication, DataBindingContext dbc) {
        Button useExistingApplicationButton = new Button(parent, 16);
        useExistingApplicationButton.setText("Use my existing OpenShift application:");
        useExistingApplicationButton.setToolTipText("If selected we will import your existing application.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)useExistingApplicationButton);
        useExitingApplication.addOption((Object)Boolean.TRUE, (IObservableValue)WidgetProperties.selection().observe((Widget)useExistingApplicationButton));
        Label existingAppLabel = new Label(parent, 0);
        existingAppLabel.setText("We will clone and import your existing application to a workspace project.");
        existingAppLabel.setForeground(this.getShell().getDisplay().getSystemColor(33));
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)existingAppLabel);
        this.existingAppNameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.existingAppNameText);
        ISWTObservableValue existingAppNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.existingAppNameText);
        ValueBindingBuilder.bind((IObservableValue)existingAppNameTextObservable).to(BeanProperties.value((String)"existingApplicationName").observe((Object)this.pageModel)).in(dbc);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.existingAppNameText)).notUpdatingParticipant()).to(useExistingApplication).in(dbc);
        this.createExistingAppNameContentAssist(this.existingAppNameText);
        IObservableValue existingApplicationsLoaded = BeanProperties.value((String)"resourcesLoaded").observe((Object)this.pageModel);
        IObservableValue existingApplicationObservable = BeanProperties.value((String)"existingApplication").observe((Object)this.pageModel);
        ExistingApplicationNameValidator existingAppValidator = new ExistingApplicationNameValidator((IObservableValue)useExitingApplication, (IObservableValue)existingAppNameTextObservable, existingApplicationObservable, existingApplicationsLoaded);
        dbc.addValidationStatusProvider((ValidationStatusProvider)existingAppValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)existingAppValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button browseAppsButton = new Button(parent, 0);
        browseAppsButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).grab(false, false).applyTo((Control)browseAppsButton);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)browseAppsButton)).notUpdatingParticipant()).to(useExistingApplication).in(dbc);
        browseAppsButton.addSelectionListener(this.onBrowseExistingApps(dbc));
    }

    private AutoCompleteField createExistingAppNameContentAssist(Text existingAppNameText) {
        AutoCompleteField autoCompleteField = new AutoCompleteField((Control)existingAppNameText, (IControlContentAdapter)new TextContentAdapter(), new String[0]);
        this.pageModel.addPropertyChangeListener("existingApplications", this.onExistingApplicationsChanged(autoCompleteField));
        ControlDecoration dec = new ControlDecoration((Control)existingAppNameText, 131200);
        FieldDecoration contentProposalFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        dec.setImage(contentProposalFieldIndicator.getImage());
        dec.setDescriptionText("Auto-completion is enabled when you start typing an application name.");
        dec.setShowOnlyOnFocus(true);
        return autoCompleteField;
    }

    protected PropertyChangeListener onExistingApplicationsChanged(final AutoCompleteField autoCompleteField) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                autoCompleteField.setProposals(ApplicationTemplateWizardPage.this.pageModel.getExistingApplicationNames());
            }
        };
    }

    private SelectionListener onBrowseExistingApps(DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectApplicationWizard selectApplicationWizard = new SelectApplicationWizard(ApplicationTemplateWizardPage.this.wizardModel);
                if (new OkCancelButtonWizardDialog(ApplicationTemplateWizardPage.this.getShell(), (IWizard)selectApplicationWizard).open() == 1) {
                    return;
                }
                IApplication selectedApplication = selectApplicationWizard.getSelectedApplication();
                if (selectedApplication != null) {
                    ApplicationTemplateWizardPage.this.pageModel.setExistingApplication(selectedApplication);
                }
            }
        };
    }

    private void createNewApplicationControls(Composite parent, SelectObservableValue useExitingApplication, IObservableValue useExistingApplication, DataBindingContext dbc) {
        Button newApplicationButton = new Button(parent, 16);
        newApplicationButton.setText("Create a new OpenShift application:");
        newApplicationButton.setToolTipText("If selected we will create a new application in OpenShift.");
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).indent(0, 20).applyTo((Control)newApplicationButton);
        useExitingApplication.addOption((Object)Boolean.FALSE, (IObservableValue)WidgetProperties.selection().observe((Widget)newApplicationButton));
        Label existingAppLabel = new Label(parent, 0);
        existingAppLabel.setText("You can create an application form scratch or handpick from existing cartridges you need.");
        existingAppLabel.setForeground(this.getShell().getDisplay().getSystemColor(33));
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)existingAppLabel);
        Composite applicationTemplatesTreeComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, true).applyTo((Control)applicationTemplatesTreeComposite);
        GridLayoutFactory.fillDefaults().spacing(2, 2).applyTo(applicationTemplatesTreeComposite);
        Text templateFilterText = UIUtils.createSearchText(applicationTemplatesTreeComposite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)templateFilterText);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)templateFilterText)).notUpdatingParticipant()).to(useExistingApplication).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        TreeViewer applicationTemplatesViewer = this.createApplicationTemplatesViewer(applicationTemplatesTreeComposite, templateFilterText);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 250).applyTo(applicationTemplatesViewer.getControl());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)applicationTemplatesViewer.getControl())).notUpdatingParticipant()).to(useExistingApplication).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        templateFilterText.addModifyListener(this.onFilterTextModified(applicationTemplatesViewer));
        IViewerObservableValue selectedApplicationTemplateViewerObservable = ViewerProperties.singleSelection().observe((Viewer)applicationTemplatesViewer);
        IObservableValue selectedApplicationTemplateModelObservable = BeanProperties.value((String)"selectedApplicationTemplate").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)selectedApplicationTemplateViewerObservable).to(selectedApplicationTemplateModelObservable).in(dbc);
        ApplicationTemplateValidator selectedApplicationTemplateValidator = new ApplicationTemplateValidator((IObservableValue)useExitingApplication, (IObservableValue)selectedApplicationTemplateViewerObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)selectedApplicationTemplateValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedApplicationTemplateValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        final Group detailsContainer = new Group(applicationTemplatesTreeComposite, 0);
        detailsContainer.setText("Details");
        this.enableTemplateDetailsControls((Composite)detailsContainer, !this.pageModel.isUseExistingApplication());
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 140).applyTo((Control)detailsContainer);
        useExistingApplication.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Boolean enabled = Boolean.FALSE.equals(event.diff.getNewValue());
                ApplicationTemplateWizardPage.this.enableTemplateDetailsControls((Composite)detailsContainer, enabled);
            }
        });
        new ApplicationTemplateDetailViews(selectedApplicationTemplateModelObservable, (IObservableValue)useExitingApplication, (Composite)detailsContainer, dbc).createControls();
    }

    private void enableTemplateDetailsControls(Composite detailsContainer, final Boolean enabled) {
        UIUtils.doForAllChildren(new UIUtils.IWidgetVisitor(){

            @Override
            public void visit(Control control) {
                control.setEnabled(enabled.booleanValue());
            }
        }, detailsContainer);
    }

    protected ModifyListener onFilterTextModified(final TreeViewer applicationTemplatesViewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                applicationTemplatesViewer.refresh();
                applicationTemplatesViewer.expandAll();
            }
        };
    }

    private TreeViewer createApplicationTemplatesViewer(Composite parent, Text filterText) {
        TreeViewer applicationTemplatesViewer = new TreeViewer(parent, 2820);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"applicationTemplates"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        applicationTemplatesViewer.setContentProvider((IContentProvider)contentProvider);
        applicationTemplatesViewer.setLabelProvider((IBaseLabelProvider)new ApplicationTemplateViewLabelProvider());
        applicationTemplatesViewer.addFilter((ViewerFilter)new ApplicationTemplateViewerFilter(filterText));
        applicationTemplatesViewer.setInput((Object)this.pageModel);
        return applicationTemplatesViewer;
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        if (!this.ensureHasDomain() || !this.ensureHasSSHKeys()) {
            this.dispose();
            org.jboss.tools.openshift.express.internal.ui.utils.WizardUtils.close(this.getWizard());
            return;
        }
        try {
            this.loadOpenshiftResources(this.existingAppNameText, dbc);
        }
        catch (OpenShiftException e) {
            Logger.error("Failed to load openshift resources.", e);
        }
    }

    protected boolean ensureHasDomain() {
        Connection connection;
        block3: {
            connection = this.pageModel.getConnection();
            try {
                if (connection != null && !connection.hasDomain()) break block3;
                return true;
            }
            catch (OpenShiftException e) {
                IStatus status = OpenShiftUIActivator.createErrorStatus(e.getMessage(), e);
                new ErrorDialog(this.getShell(), "Error", NLS.bind((String)"Could not lookup domain in OpenShift connection {0}", (Object)connection.getId()), status, 4).open();
                OpenShiftUIActivator.log(status);
                return false;
            }
        }
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)new NewDomainWizard(connection));
        dialog.create();
        dialog.setBlockOnOpen(true);
        return dialog.open() == 0;
    }

    protected boolean ensureHasSSHKeys() {
        Connection connection;
        block3: {
            connection = this.pageModel.getConnection();
            try {
                if (connection != null && !connection.hasSSHKeys()) break block3;
                return true;
            }
            catch (OpenShiftException e) {
                IStatus status = OpenShiftUIActivator.createErrorStatus(e.getMessage(), e);
                new ErrorDialog(this.getShell(), "Error", NLS.bind((String)"Could not lookup ssh keys in OpenShift connection {0}", (Object)connection.getId()), status, 4).open();
                OpenShiftUIActivator.log(status);
                return false;
            }
        }
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)new NoSSHKeysWizard(connection));
        dialog.create();
        dialog.setBlockOnOpen(true);
        return dialog.open() == 0;
    }

    protected void loadOpenshiftResources(Text existingAppNameText, DataBindingContext dbc) {
        try {
            if (this.pageModel.isResourcesLoaded()) {
                return;
            }
            WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob("Loading applications, cartridges and gears..."){

                @Override
                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        ApplicationTemplateWizardPage.this.pageModel.loadResources();
                        return Status.OK_STATUS;
                    }
                    catch (NotFoundOpenShiftException notFoundOpenShiftException) {
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return OpenShiftUIActivator.createErrorStatus("Could not load applications, cartridges and gears", e);
                    }
                }
            }, (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (Exception exception) {}
    }

    private void setWizardPageDescription(boolean useExisting) {
        if (useExisting) {
            this.setDescription("Import an existing OpenShift Application.");
        } else {
            this.setDescription("Create a new OpenShift Application.");
        }
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)13, (WizardPage)this, (DataBindingContext)dbc);
    }

    class ApplicationTemplateValidator
    extends MultiValidator {
        private final IObservableValue useExistingApplicationObservable;
        private final IObservableValue selectedApplicationTemplateObservable;

        public ApplicationTemplateValidator(IObservableValue useExistingApplicationObservable, IObservableValue selectedApplicationTemplateObservable) {
            this.useExistingApplicationObservable = useExistingApplicationObservable;
            this.selectedApplicationTemplateObservable = selectedApplicationTemplateObservable;
        }

        protected IStatus validate() {
            Boolean useExistingApplication = (Boolean)this.useExistingApplicationObservable.getValue();
            IApplicationTemplate selectedApplicationTemplate = (IApplicationTemplate)this.selectedApplicationTemplateObservable.getValue();
            if (useExistingApplication == null || useExistingApplication.booleanValue()) {
                return ValidationStatus.ok();
            }
            if (selectedApplicationTemplate == null || !selectedApplicationTemplate.canCreateApplication()) {
                return ValidationStatus.cancel((String)"Please select an existing cartridge, a quickstart or provide your own framework.");
            }
            return ValidationStatus.ok();
        }
    }

    private class ApplicationTemplateViewLabelProvider
    extends StyledCellLabelProvider {
        private ApplicationTemplateViewLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof IApplicationTemplate)) {
                return;
            }
            StyledString text = new StyledString();
            if (element instanceof ICartridgeApplicationTemplate) {
                this.createCartridgeTemplatelabel(text, (ICartridgeApplicationTemplate)element);
            } else if (element instanceof IQuickstartApplicationTemplate) {
                this.createQuickstartTemplatelabel(text, (IQuickstartApplicationTemplate)element);
            } else {
                this.createApplicationTemplateLabel(text, (IApplicationTemplate)element);
            }
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }

        private void createCartridgeTemplatelabel(StyledString text, ICartridgeApplicationTemplate cartridgeTemplate) {
            this.createApplicationTemplateLabel(text, cartridgeTemplate);
            ICartridge cartridge = cartridgeTemplate.getStandaloneCartridge();
            if (cartridge != null && !StringUtils.isEmpty((String)cartridge.getName())) {
                text.append(" ", StyledString.DECORATIONS_STYLER);
                text.append(cartridge.getName(), StyledString.DECORATIONS_STYLER);
            }
        }

        private void createQuickstartTemplatelabel(StyledString text, IQuickstartApplicationTemplate quickstartTemplate) {
            this.createApplicationTemplateLabel(text, quickstartTemplate);
            if (!StringUtils.isEmpty((String)quickstartTemplate.getName())) {
                text.append(" ", StyledString.DECORATIONS_STYLER);
                text.append(quickstartTemplate.getTagsString(), StyledString.DECORATIONS_STYLER);
            }
        }

        private void createApplicationTemplateLabel(StyledString text, IApplicationTemplate applicationTemplate) {
            text.append(applicationTemplate.getName());
        }
    }

    class ApplicationTemplateViewerFilter
    extends ViewerFilter {
        private Text filterText;

        public ApplicationTemplateViewerFilter(Text filterText) {
            Assert.isLegal((!DisposeUtils.isDisposed((Control)filterText) ? 1 : 0) != 0);
            this.filterText = filterText;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IApplicationTemplate)) {
                return false;
            }
            return ((IApplicationTemplate)element).isMatching(this.filterText.getText());
        }
    }

    class ExistingApplicationNameValidator
    extends MultiValidator {
        private final IObservableValue useExistingApplicationObservable;
        private final IObservableValue applicationNameTextObservable;
        private final IObservableValue existingApplicationObservable;
        private final IObservableValue existingApplicationsLoadedObservable;

        public ExistingApplicationNameValidator(IObservableValue useExistingAppBtnbservable, IObservableValue existingApplicationNameTextObservable, IObservableValue existingApplicationObservable, IObservableValue existingApplicationsLoadedObservable) {
            this.useExistingApplicationObservable = useExistingAppBtnbservable;
            this.applicationNameTextObservable = existingApplicationNameTextObservable;
            this.existingApplicationObservable = existingApplicationObservable;
            this.existingApplicationsLoadedObservable = existingApplicationsLoadedObservable;
        }

        protected IStatus validate() {
            Boolean useExistingApplication = (Boolean)this.useExistingApplicationObservable.getValue();
            String applicationName = (String)this.applicationNameTextObservable.getValue();
            IApplication application = (IApplication)this.existingApplicationObservable.getValue();
            Boolean existingApplicationsLoaded = (Boolean)this.existingApplicationsLoadedObservable.getValue();
            if (useExistingApplication == null || !useExistingApplication.booleanValue()) {
                return ValidationStatus.ok();
            }
            if (StringUtils.isEmpty((String)applicationName)) {
                return ValidationStatus.cancel((String)"Please select an existing OpenShift application");
            }
            if (existingApplicationsLoaded != null && !existingApplicationsLoaded.booleanValue()) {
                return ValidationStatus.cancel((String)"Existing applications are not loaded yet.");
            }
            if (application == null) {
                return ValidationStatus.error((String)NLS.bind((String)"You dont have an application called {0} in your domains.", (Object)applicationName));
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.applicationNameTextObservable);
            return targets;
        }
    }
}

