/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.utils.ContentProposalUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.StyleRangeUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.viewer.AbstractDetailViews;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICartridgeApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICodeAnythingApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IQuickstartApplicationTemplate;

public class ApplicationTemplateDetailViews
extends AbstractDetailViews {
    private final AbstractDetailViews.IDetailView defaultView = new DefaultView();
    private final AbstractDetailViews.IDetailView downloadableCartridgeView = new CodeAnthingCartridgeView();
    private final AbstractDetailViews.IDetailView quickstartView = new QuickstartView();
    private IObservableValue disabled;

    ApplicationTemplateDetailViews(IObservableValue detailViewModel, IObservableValue disabled, Composite parent, DataBindingContext dbc) {
        super(detailViewModel, parent, dbc);
        this.disabled = disabled;
    }

    @Override
    protected void createViewControls(Composite parent, DataBindingContext dbc) {
        this.downloadableCartridgeView.createControls(parent, dbc);
        this.quickstartView.createControls(parent, dbc);
        this.defaultView.createControls(parent, dbc);
        this.emptyView.createControls(parent, dbc);
    }

    @Override
    protected AbstractDetailViews.IDetailView[] getDetailViews() {
        return new AbstractDetailViews.IDetailView[]{this.quickstartView, this.downloadableCartridgeView, this.defaultView};
    }

    private class CodeAnthingCartridgeView
    extends DefaultView {
        private StyledText nameText;
        private StyledText descriptionText;
        private Text urlText;
        private Binding binding;

        private CodeAnthingCartridgeView() {
            super(null, null);
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(container);
            this.nameText = new StyledText(container, 8);
            UIUtils.setTransparent(this.nameText);
            GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
            this.descriptionText = new StyledText(container, 74);
            UIUtils.setTransparent(this.descriptionText);
            GridDataFactory.fillDefaults().span(2, 1).align(16384, 4).grab(true, true).applyTo((Control)this.descriptionText);
            Label urlLabel = new Label(container, 0);
            urlLabel.setText("Cartridge URL:");
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)urlLabel);
            this.urlText = new Text(container, 2048);
            ContentProposalUtils.createPreferencesBacked(this.urlText, "org.jboss.tools.openshift.express.CODEANYTHING_CARTRIDGES", "org.jboss.tools.openshift.express.ui");
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.urlText);
            return container;
        }

        @Override
        public void onVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            Object value = applicationTemplateObservable.getValue();
            if (!(value instanceof IApplicationTemplate) || DisposeUtils.isDisposed((Control)this.nameText)) {
                return;
            }
            IApplicationTemplate applicationTemplate = (IApplicationTemplate)value;
            String name = applicationTemplate.getName();
            this.nameText.setText(name);
            this.nameText.setStyleRange(StyleRangeUtils.createBoldStyleRange(name, null));
            this.descriptionText.setText(applicationTemplate.getDescription());
            ISWTObservableValue urlTextObservable = WidgetProperties.text((int)24).observe((Widget)this.urlText);
            this.binding = ValueBindingBuilder.bind((IObservableValue)urlTextObservable).to(BeanProperties.value((String)"url", String.class).observeDetail(applicationTemplateObservable)).in(dbc);
            CodeAnythingCartridgeUrlValidator codeAnythingCartridgeUrlValidator = new CodeAnythingCartridgeUrlValidator((IObservableValue)urlTextObservable, applicationTemplateObservable, ApplicationTemplateDetailViews.this.disabled);
            dbc.addValidationStatusProvider((ValidationStatusProvider)codeAnythingCartridgeUrlValidator);
            ControlDecorationSupport.create((ValidationStatusProvider)codeAnythingCartridgeUrlValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        }

        @Override
        public void onInVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            if (DisposeUtils.isDisposed(this.binding)) {
                return;
            }
            this.binding.dispose();
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof ICodeAnythingApplicationTemplate;
        }

        class CodeAnythingCartridgeUrlValidator
        extends MultiValidator {
            private IObservableValue url;
            private IObservableValue disabled;
            private IObservableValue applicationTemplate;

            private CodeAnythingCartridgeUrlValidator(IObservableValue url, IObservableValue template, IObservableValue disabled) {
                this.url = url;
                this.applicationTemplate = template;
                this.disabled = disabled;
            }

            protected IStatus validate() {
                String url = (String)this.url.getValue();
                IApplicationTemplate applicationTemplate = (IApplicationTemplate)this.applicationTemplate.getValue();
                Boolean disabled = (Boolean)this.disabled.getValue();
                if (Boolean.valueOf(disabled).booleanValue()) {
                    return ValidationStatus.ok();
                }
                if (applicationTemplate == null || !(applicationTemplate instanceof ICodeAnythingApplicationTemplate)) {
                    return ValidationStatus.ok();
                }
                if (StringUtils.isEmpty((String)url)) {
                    return ValidationStatus.cancel((String)"Please provide an url for your cartridge.");
                }
                if (!UrlUtils.isValid((String)url)) {
                    return ValidationStatus.error((String)NLS.bind((String)"{0} is not a valid url.", (Object)url));
                }
                return ValidationStatus.ok();
            }
        }
    }

    private class DefaultView
    extends AbstractDetailViews.EmptyView {
        private StyledText nameText;
        private StyledText descriptionText;

        private DefaultView() {
            super(ApplicationTemplateDetailViews.this);
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(super.createControls(parent, dbc));
            GridLayoutFactory.fillDefaults().margins(10, 10).spacing(10, 10).applyTo(container);
            this.nameText = new StyledText(container, 8);
            UIUtils.setTransparent(this.nameText);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
            this.descriptionText = new StyledText(container, 74);
            UIUtils.setTransparent(this.descriptionText);
            GridDataFactory.fillDefaults().align(16384, 4).grab(true, true).applyTo((Control)this.descriptionText);
            return container;
        }

        @Override
        public void onVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            Object value = applicationTemplateObservable.getValue();
            if (!(value instanceof IApplicationTemplate) || DisposeUtils.isDisposed((Control)this.nameText)) {
                return;
            }
            IApplicationTemplate applicationTemplate = (IApplicationTemplate)value;
            String templateName = applicationTemplate.getName();
            this.nameText.setText(templateName);
            this.nameText.setStyleRange(StyleRangeUtils.createBoldStyleRange(templateName, null));
            this.descriptionText.setText(applicationTemplate.getDescription());
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof ICartridgeApplicationTemplate;
        }

        /* synthetic */ DefaultView(DefaultView defaultView, DefaultView defaultView2) {
            this();
        }
    }

    private class QuickstartView
    extends AbstractDetailViews.EmptyView {
        private Link nameLink;
        private CLabel openshiftMaintainedLabel;
        private CLabel securityUpdatesLabel;
        private StyledText summaryText;

        private QuickstartView() {
            super(ApplicationTemplateDetailViews.this);
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(4, 4).numColumns(4).spacing(6, 6).applyTo(container);
            this.nameLink = new Link(container, 0);
            GridDataFactory.fillDefaults().indent(6, 0).align(16384, 0x1000000).applyTo((Control)this.nameLink);
            this.openshiftMaintainedLabel = new CLabel(container, 0);
            GridDataFactory.fillDefaults().indent(6, 0).align(4, 4).applyTo((Control)this.openshiftMaintainedLabel);
            this.securityUpdatesLabel = new CLabel(container, 0);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.securityUpdatesLabel);
            this.summaryText = new StyledText(container, 584);
            this.summaryText.setAlwaysShowScrollBars(false);
            UIUtils.setTransparent(this.summaryText);
            Rectangle containerSize = container.getClientArea();
            GridDataFactory.fillDefaults().span(3, 1).indent(6, 0).align(4, 4).grab(true, true).hint(containerSize.x, -1).applyTo((Control)this.summaryText);
            return container;
        }

        @Override
        public void onVisible(IObservableValue applicationTemplateObservable, DataBindingContext dbc) {
            Object value = applicationTemplateObservable.getValue();
            if (!(value instanceof IQuickstartApplicationTemplate) || DisposeUtils.isDisposed((Control)this.nameLink)) {
                return;
            }
            IQuickstartApplicationTemplate template = (IQuickstartApplicationTemplate)value;
            this.nameLink.setText("<a>" + template.getName() + "</a>");
            this.nameLink.addSelectionListener(this.onLinkClicked(template.getHref()));
            this.updateOpenShiftMaintainedIcon(template);
            this.updateSecurityUpdatesIcon(template);
            this.summaryText.setText(template.getDescription());
        }

        private void updateOpenShiftMaintainedIcon(IQuickstartApplicationTemplate template) {
            if (template.isOpenShiftMaintained()) {
                this.setImageAndTooltip(this.openshiftMaintainedLabel, "OpenShift maintained", OpenShiftImages.OPENSHIFT_MAINTAINED_IMG);
            } else {
                this.setImageAndTooltip(this.openshiftMaintainedLabel, "Community created", OpenShiftImages.NOT_OPENSHIFT_MAINTAINED_IMG);
            }
        }

        private void updateSecurityUpdatesIcon(IQuickstartApplicationTemplate template) {
            if (template.isAutomaticSecurityUpdates()) {
                this.setImageAndTooltip(this.securityUpdatesLabel, "automatic security updates", OpenShiftImages.SECURITY_UPDATES_IMG);
            } else {
                this.setImageAndTooltip(this.securityUpdatesLabel, "no automatic security updates", OpenShiftImages.NO_SECURITY_UPDATES_IMG);
            }
        }

        private void setImageAndTooltip(CLabel label, String text, Image image) {
            label.setImage(image);
            label.setToolTipText(text);
        }

        private SelectionListener onLinkClicked(final String url) {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new BrowserUtility().checkedCreateExternalBrowser(url, "org.jboss.tools.openshift.express.ui", OpenShiftUIActivator.getDefault().getLog());
                }
            };
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof IQuickstartApplicationTemplate;
        }
    }
}

