/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.OpenShiftUserPreferencesProvider;
import org.jboss.tools.openshift.express.internal.ui.utils.PojoEventBridge;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;

public class ApplicationConfigurationWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_APPLICATION_NAME = "applicationName";
    public static final String PROPERTY_APPLICATION_SCALE = "scale";
    public static final String PROPERTY_CAN_ADDREMOVE_CARTRIDGES = "canAddRemoveCartridges";
    public static final String PROPERTY_DOMAIN = "domain";
    public static final String PROPERTY_DOMAINS = "domains";
    public static final String PROPERTY_EMBEDDED_CARTRIDGES = "embeddedCartridges";
    public static final String PROPERTY_EMBEDDABLE_CARTRIDGES = "embeddableCartridges";
    public static final String PROPERTY_ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String PROPERTY_ENVIRONMENT_VARIABLES_SUPPORTED = "environmentVariablesSupported";
    public static final String PROPERTY_EXISTING_APPLICATIONS = "existingApplications";
    public static final String PROPERTY_GEAR_PROFILES = "gearProfiles";
    public static final String PROPERTY_INITIAL_GITURL = "initialGitUrl";
    public static final String PROPERTY_RESOURCES_LOADED = "resourcesLoaded";
    public static final String PROPERTY_SCALABLE_APPLICATION = "scalableApplication";
    public static final String PROPERTY_SELECTED_APPLICATION_TEMPLATE = "selectedApplicationTemplate";
    public static final String PROPERTY_SELECTED_CARTRIDGE = "selectedCartridge";
    public static final String PROPERTY_SELECTED_GEAR_PROFILE = "selectedGearProfile";
    public static final String PROPERTY_USE_EXISTING_APPLICATION = "useExistingApplication";
    public static final String PROPERTY_USE_INITIAL_GITURL = "useInitialGitUrl";
    public static final String PROPERTY_INITIAL_GITURL_EDITABLE = "initialGitUrlEditable";
    public static final String PROPERTY_EXISTING_INITIAL_GITURL_EDITABLE = "existingInitialGitUrlEditable";
    private final OpenShiftApplicationWizardModel wizardModel;
    private List<IApplication> existingApplications = new ArrayList<IApplication>();
    private List<IGearProfile> gearProfiles = new ArrayList<IGearProfile>();
    private String existingApplicationName;
    private boolean resourcesLoaded = false;
    private ICartridge selectedCartridge;
    private OpenShiftUserPreferencesProvider openShiftUserPreferencesProvider = new OpenShiftUserPreferencesProvider();

    protected ApplicationConfigurationWizardPageModel(OpenShiftApplicationWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.setupWizardModelListeners(wizardModel);
    }

    protected void setupWizardModelListeners(OpenShiftApplicationWizardModel wizardModel) {
        new PojoEventBridge().listenTo(PROPERTY_DOMAIN, wizardModel).forwardTo(PROPERTY_DOMAIN, (ObservablePojo)this);
        new PojoEventBridge().listenTo(PROPERTY_DOMAINS, wizardModel).forwardTo(PROPERTY_DOMAINS, (ObservablePojo)this);
        new PojoEventBridge().listenTo(PROPERTY_APPLICATION_NAME, wizardModel).forwardTo(PROPERTY_APPLICATION_NAME, (ObservablePojo)this);
        new PojoEventBridge().listenTo(PROPERTY_EMBEDDED_CARTRIDGES, wizardModel).forwardTo(PROPERTY_EMBEDDED_CARTRIDGES, (ObservablePojo)this);
        new PojoEventBridge().listenTo(PROPERTY_USE_EXISTING_APPLICATION, wizardModel).forwardTo(PROPERTY_USE_EXISTING_APPLICATION, (ObservablePojo)this);
        new PojoEventBridge().listenTo(PROPERTY_EMBEDDED_CARTRIDGES, wizardModel).forwardTo(PROPERTY_EMBEDDABLE_CARTRIDGES, (ObservablePojo)this);
        new PojoEventBridge(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                ApplicationConfigurationWizardPageModel.this.firePropertyChange(ApplicationConfigurationWizardPageModel.PROPERTY_SELECTED_APPLICATION_TEMPLATE, event.getOldValue(), event.getNewValue());
                ApplicationConfigurationWizardPageModel.this.fireCanAddRemoveCartridges();
                ApplicationConfigurationWizardPageModel.this.fireInitialGitUrlEditable();
                ApplicationConfigurationWizardPageModel.this.fireExistingInitialGitUrlEditable();
            }
        }.listenTo(PROPERTY_SELECTED_APPLICATION_TEMPLATE, wizardModel);
        new PojoEventBridge().listenTo(PROPERTY_USE_INITIAL_GITURL, wizardModel).forwardTo(PROPERTY_USE_INITIAL_GITURL, (ObservablePojo)this);
        new PojoEventBridge().listenTo(PROPERTY_INITIAL_GITURL, wizardModel).forwardTo(PROPERTY_INITIAL_GITURL, (ObservablePojo)this);
    }

    public Connection getConnection() {
        return this.wizardModel.getConnection();
    }

    public ApplicationScale getScale() {
        return this.wizardModel.getApplicationScale();
    }

    public void setScale(ApplicationScale scale) {
        this.firePropertyChange(PROPERTY_APPLICATION_SCALE, this.wizardModel.getApplicationScale(), this.wizardModel.setApplicationScale(scale));
    }

    public String getExistingApplicationName() {
        return this.existingApplicationName;
    }

    protected IApplication getApplicationByName(String applicationName, IDomain domain) {
        IApplication application = null;
        if (domain != null && !StringUtils.isEmpty((String)applicationName) && this.isExistingApplication(applicationName)) {
            application = domain.getApplicationByName(applicationName);
        }
        return application;
    }

    public void loadExistingApplications() throws OpenShiftException {
        IDomain domain = this.getDomain();
        if (domain == null) {
            return;
        }
        this.setResourcesLoaded(false);
        this.setExistingApplications(domain.getApplications());
        this.setResourcesLoaded(true);
    }

    public void setResourcesLoaded(boolean loaded) {
        this.resourcesLoaded = loaded;
        this.firePropertyChange(PROPERTY_RESOURCES_LOADED, this.resourcesLoaded, this.resourcesLoaded);
    }

    public boolean isResourcesLoaded() {
        return this.resourcesLoaded;
    }

    public boolean isExistingApplication(String applicationName) {
        return this.getExistingApplication(applicationName, this.getDomain()) != null;
    }

    private IApplication getExistingApplication(String applicationName, IDomain domain) {
        if (domain == null || applicationName == null) {
            return null;
        }
        return domain.getApplicationByName(applicationName);
    }

    public void setExistingApplications(List<IApplication> existingApplications) {
        this.existingApplications = existingApplications;
        this.firePropertyChange(PROPERTY_EXISTING_APPLICATIONS, this.existingApplications, this.existingApplications);
    }

    public List<IApplication> getExistingApplications() {
        return this.existingApplications;
    }

    public void loadResources() throws OpenShiftException {
        Connection connection = this.getConnection();
        if (!this.wizardModel.isValid(connection)) {
            return;
        }
        this.setResourcesLoaded(false);
        this.loadGearProfiles(this.getDomain());
        this.setEmbeddableCartridges(new ArrayList<ICartridge>(connection.getEmbeddableCartridges()));
        this.setResourcesLoaded(true);
    }

    public IApplicationTemplate getSelectedApplicationTemplate() {
        return this.wizardModel.getSelectedApplicationTemplate();
    }

    private void loadGearProfiles(IDomain domain) throws OpenShiftException {
        if (domain == null) {
            return;
        }
        this.setGearProfiles(domain.getAvailableGearProfiles());
    }

    public void setGearProfiles(List<IGearProfile> gearProfiles) {
        this.gearProfiles = gearProfiles;
        this.firePropertyChange(PROPERTY_GEAR_PROFILES, this.gearProfiles, this.gearProfiles);
    }

    public List<IGearProfile> getGearProfiles() {
        return this.gearProfiles;
    }

    public IGearProfile getSelectedGearProfile() {
        return this.wizardModel.getApplicationGearProfile();
    }

    public void setSelectedGearProfile(IGearProfile gearProfile) {
        this.firePropertyChange(PROPERTY_SELECTED_GEAR_PROFILE, this.wizardModel.getApplicationGearProfile(), this.wizardModel.setApplicationGearProfile(gearProfile));
    }

    public IGearProfile getGearProfileByName(String name) {
        List<IGearProfile> gearProfiles = this.getGearProfiles();
        if (gearProfiles == null || name == null) {
            return null;
        }
        IGearProfile matchingGearProfile = null;
        for (IGearProfile gearProfile : gearProfiles) {
            if (!name.equals(gearProfile.getName())) continue;
            matchingGearProfile = gearProfile;
            break;
        }
        return matchingGearProfile;
    }

    public void setApplicationName(String applicationName) {
        this.wizardModel.setApplicationName(applicationName);
    }

    public String getApplicationName() {
        return this.wizardModel.getApplicationName();
    }

    public IApplication getApplication() {
        return this.wizardModel.getApplication();
    }

    public void setEmbeddableCartridges(List<ICartridge> embeddableCartridges) {
        this.wizardModel.setAvailableEmbeddableCartridges(embeddableCartridges);
    }

    public List<ICartridge> getEmbeddableCartridges() {
        return this.wizardModel.getAvailableEmbeddableCartridges();
    }

    public void setEmbeddedCartridges(Set<ICartridge> selectedEmbeddableCartridges) {
        this.wizardModel.setEmbeddedCartridges(selectedEmbeddableCartridges);
    }

    public Set<ICartridge> getEmbeddedCartridges() throws OpenShiftException {
        return this.wizardModel.getEmbeddedCartridges();
    }

    public void addEmbeddedCartridges(ICartridge cartridge) throws OpenShiftException {
        this.wizardModel.addEmbeddedCartridges(Collections.singletonList(cartridge));
    }

    public void removeEmbeddedCartridges(ICartridge cartridge) throws OpenShiftException {
        this.wizardModel.removeEmbeddedCartridges(Collections.singletonList(cartridge));
    }

    public ICartridge getSelectedCartridge() throws OpenShiftException {
        return this.selectedCartridge;
    }

    public void setSelectedCartridge(ICartridge selectedEmbeddableCartridge) {
        this.selectedCartridge = selectedEmbeddableCartridge;
        this.firePropertyChange(PROPERTY_SELECTED_CARTRIDGE, this.selectedCartridge, this.selectedCartridge);
    }

    public void removeSelectedEmbeddableCartridge(IEmbeddableCartridge cartridge) {
        this.wizardModel.removeEmbeddedCartridge((ICartridge)cartridge);
    }

    protected void fireCanAddRemoveCartridges() {
        this.firePropertyChange(PROPERTY_CAN_ADDREMOVE_CARTRIDGES, !this.isCanAddRemoveCartridges(), this.isCanAddRemoveCartridges());
    }

    public boolean isCanAddRemoveCartridges() {
        return this.getSelectedApplicationTemplate() != null && this.getSelectedApplicationTemplate().canAddRemoveCartridges();
    }

    protected void fireInitialGitUrlEditable() {
        this.firePropertyChange(PROPERTY_INITIAL_GITURL_EDITABLE, null, this.isInitialGitUrlEditable());
    }

    public boolean isInitialGitUrlEditable() {
        return this.getSelectedApplicationTemplate() != null && this.getSelectedApplicationTemplate().isInitialGitUrlEditable();
    }

    protected void fireExistingInitialGitUrlEditable() {
        this.firePropertyChange(PROPERTY_EXISTING_INITIAL_GITURL_EDITABLE, null, this.isInitialGitUrlEditable());
    }

    public boolean isExistingInitialGitUrlEditable() {
        return this.isUseInitialGitUrl() && this.isInitialGitUrlEditable();
    }

    public boolean hasApplication(String applicationName) throws OpenShiftException {
        Connection connection = this.getConnection();
        if (this.wizardModel.isValid(connection)) {
            return false;
        }
        return connection.hasApplication(applicationName, this.getDomain());
    }

    public boolean isCurrentDomain(IDomain domain) {
        if (this.getDomain() == null) {
            return domain == null;
        }
        return this.getDomain().equals(domain);
    }

    public IDomain getDomain() throws OpenShiftException {
        return this.wizardModel.getDomain();
    }

    public void setDomain(IDomain domain) throws OpenShiftException {
        this.wizardModel.setDomain(domain);
        this.setEnvironmentVariablesSupported(this.isEnvironmentVariablesSupported());
    }

    public List<IDomain> getDomains() throws OpenShiftException {
        return this.wizardModel.getDomains();
    }

    public void setDomains(List<IDomain> domains) throws OpenShiftException {
        this.wizardModel.setDomains(domains);
    }

    public boolean isUseInitialGitUrl() {
        return this.wizardModel.isUseInitialGitUrl();
    }

    public void setUseInitialGitUrl(boolean useInitialGitUrl) {
        this.wizardModel.setUseInitialGitUrl(useInitialGitUrl);
        this.fireExistingInitialGitUrlEditable();
    }

    public String getInitialGitUrl() {
        return this.wizardModel.getInitialGitUrl();
    }

    public void setInitialGitUrl(String initialGitUrl) {
        this.firePropertyChange(PROPERTY_INITIAL_GITURL, this.wizardModel.getInitialGitUrl(), this.wizardModel.setInitialGitUrl(initialGitUrl));
    }

    public void resetInitialGitUrl() {
        this.setInitialGitUrl(null);
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.wizardModel.getEnvironmentVariables();
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.firePropertyChange(PROPERTY_ENVIRONMENT_VARIABLES, this.wizardModel.getEnvironmentVariables(), this.wizardModel.setEnvironmentVariables(environmentVariables));
    }

    public void setEnvironmentVariablesSupported(boolean supported) {
        this.firePropertyChange(PROPERTY_ENVIRONMENT_VARIABLES_SUPPORTED, null, this.isEnvironmentVariablesSupported());
    }

    public boolean isEnvironmentVariablesSupported() {
        return this.getDomain() != null && this.getDomain().canCreateApplicationWithEnvironmentVariables();
    }

    public boolean isUseExistingApplication() {
        return this.wizardModel.isUseExistingApplication();
    }
}

