/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.utils;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class WizardUtils {
    private WizardUtils() {
    }

    public static void close(IWizard wizard) {
        IWizardContainer container = wizard.getContainer();
        if (container instanceof WizardDialog) {
            ((WizardDialog)container).close();
        }
    }

    public static boolean openWizard(int width, int height, IWizard wizard, Shell shell) {
        WizardDialog dialog = WizardUtils.createWizardDialog(wizard, shell);
        dialog.setMinimumPageSize(width, height);
        return dialog.open() == 0;
    }

    public static boolean openWizard(IWizard wizard, Shell shell) {
        WizardDialog dialog = WizardUtils.createWizardDialog(wizard, shell);
        return dialog.open() == 0;
    }

    private static WizardDialog createWizardDialog(IWizard wizard, Shell shell) {
        WizardDialog dialog = new WizardDialog(shell, wizard);
        dialog.create();
        return dialog;
    }

    public static boolean openWizard(IWorkbenchWizard wizard, Shell shell) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            return WizardUtils.openWizard(wizard, shell, (IStructuredSelection)selection);
        }
        return WizardUtils.openWizard(wizard, shell, null);
    }

    public static boolean openWizard(IWorkbenchWizard wizard, Shell shell, IStructuredSelection selection) {
        WizardDialog wizardDialog = WizardUtils.createWizardDialog((IWizard)wizard, shell);
        wizard.init(PlatformUI.getWorkbench(), selection);
        return wizardDialog.open() == 0;
    }
}

