/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.utils;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.ui.preferencevalue.StringsPreferenceValue;

public class ContentProposalUtils {
    public static ContentProposalAdapter createPreferencesBacked(final Text text, String preferencesKey, String pluginId) {
        final ControlDecoration decoration = ContentProposalUtils.createContenAssistDecoration("History available", (Control)text);
        final StringsPreferenceValue preferencesValues = new StringsPreferenceValue(',', preferencesKey, pluginId);
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(preferencesValues.get());
        proposalProvider.setFiltering(true);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                decoration.show();
            }

            public void focusLost(FocusEvent e) {
                decoration.hide();
                String value = text.getText();
                if (value != null && value.length() > 0) {
                    preferencesValues.add(text.getText());
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
        ContentProposalAdapter proposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, keyStroke, null);
        proposalAdapter.setProposalAcceptanceStyle(2);
        return proposalAdapter;
    }

    private static ControlDecoration createContenAssistDecoration(String tooltip, Control control) {
        return ContentProposalUtils.createDecoration(tooltip, "DEC_CONTENT_PROPOSAL", 131200, control);
    }

    private static ControlDecoration createDecoration(String text, String fieldDecorationImageKey, int position, Control control) {
        ControlDecoration decoration = new ControlDecoration(control, position);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationImageKey).getImage();
        decoration.setImage(errorImage);
        decoration.setDescriptionText(text);
        decoration.setShowHover(true);
        decoration.hide();
        return decoration;
    }
}

