/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.server;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.ServerWorkingCopyPropertyButtonCommand;
import org.jboss.ide.eclipse.as.ui.editor.ServerWorkingCopyPropertyComboCommand;
import org.jboss.ide.eclipse.as.ui.editor.ServerWorkingCopyPropertyCommand;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionURL;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenshiftUIMessages;

public class OpenShiftServerEditorSection
extends ServerEditorSection {
    private static final String DEFAULT_HOST_MARKER = " (default)";
    private IEditorInput input;
    protected Text connectionText;
    protected Text remoteText;
    protected Text deployFolderText;
    protected Text appNameText;
    protected Text domainNameText;
    protected Combo deployProjectCombo;
    protected Button verifyButton;
    protected Button browseDestButton;
    protected Button overrideProjectSettings;
    protected Group projectSettingGroup;
    ModifyListener remoteModifyListener;
    ModifyListener deployDestinationModifyListener;
    ModifyListener deployProjectListener;
    SelectionListener overrideListener;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.input = input;
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText("OpenShift Server");
        section.setLayoutData((Object)new GridData(1808));
        Composite c = toolkit.createComposite((Composite)section, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(c);
        this.createWidgets(c, toolkit);
        toolkit.paintBordersFor(c);
        toolkit.adapt(c);
        section.setClient((Control)c);
        this.initWidgets();
        this.addListeners();
    }

    protected void initWidgets() {
        this.deployProjectCombo.setEnabled(true);
        ConnectionURL connectionUrl = OpenShiftServerUtils.getConnectionUrl((IServerAttributes)this.server);
        this.connectionText.setText(this.createConnectionLabel(connectionUrl));
        String domainName = OpenShiftServerUtils.getDomainName((IServerAttributes)this.server);
        this.domainNameText.setText(StringUtils.null2emptyString((String)domainName));
        String appName = OpenShiftServerUtils.getApplicationName((IServerAttributes)this.server);
        this.appNameText.setText(StringUtils.null2emptyString((String)appName));
        this.connectionText.setEnabled(false);
        this.domainNameText.setEnabled(false);
        this.appNameText.setEnabled(false);
        this.deployFolderText.setText(StringUtils.null2emptyString((String)OpenShiftServerUtils.getDeployFolder((IServerAttributes)this.server)));
        String remote = OpenShiftServerUtils.getRemoteName((IServerAttributes)this.server);
        this.remoteText.setText(StringUtils.null2emptyString((String)remote));
        this.deployProjectCombo.setItems(this.getSuitableProjects());
        int index = this.getProjectIndex(OpenShiftServerUtils.getDeployProjectName((IServerAttributes)this.server), Arrays.asList(this.deployProjectCombo.getItems()));
        if (index > -1) {
            this.deployProjectCombo.select(index);
        }
        boolean overrides = OpenShiftServerUtils.getOverridesProject((IServerAttributes)this.server);
        this.overrideProjectSettings.setSelection(overrides);
        this.remoteText.setEnabled(overrides);
        this.deployFolderText.setEnabled(overrides);
        this.browseDestButton.setEnabled(overrides);
    }

    private int getProjectIndex(String deployProject, List<String> deployProjectNames) {
        if (deployProject == null) {
            return -1;
        }
        return deployProjectNames.indexOf(deployProject);
    }

    private String createConnectionLabel(ConnectionURL connectionUrl) {
        String connectionLabel = "";
        if (connectionUrl != null) {
            Connection connection = new Connection(connectionUrl.getUsername(), connectionUrl.getHost());
            StringBuilder builder = new StringBuilder(connection.getUsername()).append(" - ").append(connection.getHost());
            if (connectionUrl.isDefaultHost()) {
                builder.append(DEFAULT_HOST_MARKER);
            }
            connectionLabel = builder.toString();
        }
        return connectionLabel;
    }

    private String[] getSuitableProjects() {
        IProject[] allProjects = OpenShiftServerUtils.findAllSuitableOpenshiftProjects();
        String[] allProjectNames = new String[allProjects.length];
        int i = 0;
        while (i < allProjects.length) {
            allProjectNames[i] = allProjects[i].getName();
            ++i;
        }
        return allProjectNames;
    }

    protected Composite createComposite(Section section) {
        this.createWidgets((Composite)section, new FormToolkit(section.getDisplay()));
        return section;
    }

    private void createWidgets(Composite composite, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        toolkit.createLabel(composite, OpenshiftUIMessages.EditorSectionDeployLocLabel, 0);
        this.deployProjectCombo = new Combo(composite, 2060);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.deployProjectCombo);
        this.projectSettingGroup = new Group(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.projectSettingGroup);
        this.projectSettingGroup.setLayout((Layout)new GridLayout(2, false));
        this.projectSettingGroup.setText(OpenshiftUIMessages.EditorSectionProjectSettingsGroup);
        this.overrideProjectSettings = toolkit.createButton((Composite)this.projectSettingGroup, OpenshiftUIMessages.EditorSectionOverrideProjectSettings, 32);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.overrideProjectSettings);
        Label userLabel = toolkit.createLabel((Composite)this.projectSettingGroup, OpenshiftUIMessages.EditorSectionConnectionLabel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)userLabel);
        this.connectionText = toolkit.createText((Composite)this.projectSettingGroup, "", 2052);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.connectionText);
        Label domainNameLabel = toolkit.createLabel((Composite)this.projectSettingGroup, OpenshiftUIMessages.EditorSectionDomainNameLabel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)domainNameLabel);
        this.domainNameText = toolkit.createText((Composite)this.projectSettingGroup, "", 2052);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.domainNameText);
        Label appNameLabel = toolkit.createLabel((Composite)this.projectSettingGroup, OpenshiftUIMessages.EditorSectionAppNameLabel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)appNameLabel);
        this.appNameText = toolkit.createText((Composite)this.projectSettingGroup, "", 2052);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.appNameText);
        toolkit.createLabel((Composite)this.projectSettingGroup, OpenshiftUIMessages.EditorSectionOutputDestLabel, 0);
        Composite outputDestComposite = toolkit.createComposite((Composite)this.projectSettingGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)outputDestComposite);
        outputDestComposite.setLayout((Layout)new FormLayout());
        this.browseDestButton = toolkit.createButton(outputDestComposite, OpenshiftUIMessages.EditorSectionBrowseDestButton, 8);
        this.browseDestButton.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, (Object)100, (int)-5, null, (int)0, (Object)100, (int)0));
        this.deployFolderText = toolkit.createText(outputDestComposite, "", 2052);
        this.deployFolderText.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, (Object)100, (int)-5, (Object)0, (int)0, (Object)this.browseDestButton, (int)-5));
        Label remoteLabel = toolkit.createLabel((Composite)this.projectSettingGroup, OpenshiftUIMessages.EditorSectionRemoteLabel, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)remoteLabel);
        this.remoteText = toolkit.createText((Composite)this.projectSettingGroup, "", 2052);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.remoteText);
    }

    protected void addListeners() {
        this.deployProjectListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int ind = OpenShiftServerEditorSection.this.deployProjectCombo.getSelectionIndex();
                String newVal = ind == -1 ? null : OpenShiftServerEditorSection.this.deployProjectCombo.getItem(ind);
                ((ServerEditorPartInput)OpenShiftServerEditorSection.this.input).getServerCommandManager().execute((IUndoableOperation)new SetProjectCommand(OpenShiftServerEditorSection.this.server, newVal));
            }
        };
        this.deployProjectCombo.addModifyListener(this.deployProjectListener);
        this.overrideListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ServerEditorPartInput)OpenShiftServerEditorSection.this.input).getServerCommandManager().execute((IUndoableOperation)new SetOverrideCommand(OpenShiftServerEditorSection.this.server));
            }
        };
        this.overrideProjectSettings.addSelectionListener(this.overrideListener);
        this.remoteModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ServerEditorPartInput)OpenShiftServerEditorSection.this.input).getServerCommandManager().execute((IUndoableOperation)new SetRemoteCommand(OpenShiftServerEditorSection.this.server));
            }
        };
        this.remoteText.addModifyListener(this.remoteModifyListener);
        this.deployDestinationModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ServerEditorPartInput)OpenShiftServerEditorSection.this.input).getServerCommandManager().execute((IUndoableOperation)new SetDeployFolderCommand(OpenShiftServerEditorSection.this.server));
            }
        };
        this.deployFolderText.addModifyListener(this.deployDestinationModifyListener);
        this.browseDestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenShiftServerEditorSection.this.browsePressed();
            }
        });
    }

    private void browsePressed() {
        IFolder f = this.chooseFolder();
        if (f != null) {
            this.deployFolderText.setText(f.getFullPath().removeFirstSegments(1).makeRelative().toOSString());
        }
    }

    private IFolder chooseFolder() {
        String depProject = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)this.server);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(depProject);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Deploy Location");
        dialog.setMessage("Please choose a location to put zipped projects");
        dialog.setInput((Object)p);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = p.findMember((IPath)new Path(StringUtils.null2emptyString((String)OpenShiftServerUtils.getDeployFolder((IServerAttributes)this.server))));
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private void updateWidgetsFromWorkingCopy() {
        ConnectionURL connectionUrl = OpenShiftServerUtils.getConnectionUrl((IServerAttributes)this.server);
        this.connectionText.setText(this.createConnectionLabel(connectionUrl));
        String appName = OpenShiftServerUtils.getApplicationName((IServerAttributes)this.server);
        this.appNameText.setText(StringUtils.null2emptyString((String)appName));
        String domainName = OpenShiftServerUtils.getDomainName((IServerAttributes)this.server);
        this.domainNameText.setText(StringUtils.null2emptyString((String)domainName));
        this.browseDestButton.setEnabled(this.overrideProjectSettings.getSelection());
        this.deployFolderText.setEnabled(this.overrideProjectSettings.getSelection());
        this.remoteText.setEnabled(this.overrideProjectSettings.getSelection());
        String remote = OpenShiftServerUtils.getRemoteName((IServerAttributes)this.server, (int)OpenShiftServerUtils.SETTING_FROM_PROJECT);
        String depFolder = OpenShiftServerUtils.getDeployFolder((IServerAttributes)this.server, (int)OpenShiftServerUtils.SETTING_FROM_PROJECT);
        this.remoteText.removeModifyListener(this.remoteModifyListener);
        this.deployFolderText.removeModifyListener(this.deployDestinationModifyListener);
        this.remoteText.setText(StringUtils.null2emptyString((String)remote));
        this.deployFolderText.setText(StringUtils.null2emptyString((String)depFolder));
        this.remoteText.addModifyListener(this.remoteModifyListener);
        this.deployFolderText.addModifyListener(this.deployDestinationModifyListener);
    }

    public class SetDeployFolderCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetDeployFolderCommand(IServerWorkingCopy server) {
            super(server, "Change Deployment Folder", OpenShiftServerEditorSection.this.deployFolderText, OpenShiftServerEditorSection.this.deployFolderText.getText(), "org.jboss.tools.openshift.express.internal.core.server.DEPLOY_FOLDER_LOC", OpenShiftServerEditorSection.this.deployDestinationModifyListener, OpenShiftServerUtils.getDefaultDeployFolder((IServerAttributes)server));
        }
    }

    public class SetOverrideCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetOverrideCommand(IServerWorkingCopy wc) {
            super(wc, "Override OpenShift Project Settings Command", OpenShiftServerEditorSection.this.overrideProjectSettings, OpenShiftServerEditorSection.this.overrideProjectSettings.getSelection(), "org.jboss.tools.openshift.project.override", OpenShiftServerEditorSection.this.overrideListener);
        }

        protected void postOp(int type) {
            OpenShiftServerEditorSection.this.updateWidgetsFromWorkingCopy();
        }
    }

    public class SetProjectCommand
    extends ServerWorkingCopyPropertyComboCommand {
        public SetProjectCommand(IServerWorkingCopy wc, String newVal) {
            super(wc, "Change OpenShift Project", OpenShiftServerEditorSection.this.deployProjectCombo, newVal, "org.jboss.tools.openshift.binary.deployProject", OpenShiftServerEditorSection.this.deployProjectListener);
        }

        protected void postOp(int type) {
            OpenShiftServerEditorSection.this.updateWidgetsFromWorkingCopy();
        }
    }

    public class SetRemoteCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetRemoteCommand(IServerWorkingCopy server) {
            super(server, "Change Remote Name", OpenShiftServerEditorSection.this.remoteText, OpenShiftServerEditorSection.this.remoteText.getText(), "org.jboss.tools.openshift.express.internal.core.server.RemoteName", OpenShiftServerEditorSection.this.remoteModifyListener, "origin");
        }
    }
}

